/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.util;

import java.util.UUID;

public final class UUIDUtil {
    public static final int UUID_LENGTH = 16;

    private UUIDUtil() {
    }

    public static UUID deserialize(byte[] bytes) {
        long mostSignificantBits = UUIDUtil.bytesToLong(bytes, 0);
        long leastSignificantBits = UUIDUtil.bytesToLong(bytes, 8);
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public static byte[] serialize(UUID uuid) {
        byte[] bytes = new byte[16];
        UUIDUtil.longToBytes(uuid.getMostSignificantBits(), bytes, 0);
        UUIDUtil.longToBytes(uuid.getLeastSignificantBits(), bytes, 8);
        return bytes;
    }

    private static void longToBytes(long l, byte[] result, int offset) {
        for (int i = 7; i >= 0; --i) {
            result[i + offset] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    private static long bytesToLong(byte[] b, int offset) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i + offset] & 0xFF);
        }
        return result;
    }
}

