/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.profiles;

import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;
import org.signal.zkgroup.profiles.ProfileKeyCredentialRequest;

public final class ProfileKeyCredentialRequestContext
extends ByteArray {
    public static final int SIZE = 473;

    public ProfileKeyCredentialRequestContext(byte[] contents) throws InvalidInputException {
        super(contents, 473);
        int ffi_return = Native.profileKeyCredentialRequestContextCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new InvalidInputException("FFI_RETURN_INPUT_ERROR");
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public ProfileKeyCredentialRequest getRequest() {
        byte[] newContents = new byte[329];
        int ffi_return = Native.profileKeyCredentialRequestContextGetRequestJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyCredentialRequest(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

