/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.profiles;

import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.zkgroup.groups.UuidCiphertext;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;

public final class ProfileKeyCredentialPresentation
extends ByteArray {
    public static final int SIZE = 713;

    public ProfileKeyCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents, 713);
        int ffi_return = Native.profileKeyCredentialPresentationCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new InvalidInputException("FFI_RETURN_INPUT_ERROR");
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public UuidCiphertext getUuidCiphertext() {
        byte[] newContents = new byte[65];
        int ffi_return = Native.profileKeyCredentialPresentationGetUuidCiphertextJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKeyCiphertext getProfileKeyCiphertext() {
        byte[] newContents = new byte[65];
        int ffi_return = Native.profileKeyCredentialPresentationGetProfileKeyCiphertextJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

