/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.profiles;

import java.util.UUID;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;
import org.signal.zkgroup.profiles.ProfileKeyCommitment;
import org.signal.zkgroup.profiles.ProfileKeyVersion;
import org.signal.zkgroup.util.UUIDUtil;

public final class ProfileKey
extends ByteArray {
    public static final int SIZE = 32;

    public ProfileKey(byte[] contents) throws InvalidInputException {
        super(contents, 32);
    }

    public ProfileKeyCommitment getCommitment(UUID uuid) {
        byte[] newContents = new byte[97];
        int ffi_return = Native.profileKeyGetCommitmentJNI(this.contents, UUIDUtil.serialize(uuid), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyCommitment(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKeyVersion getProfileKeyVersion(UUID uuid) {
        byte[] newContents = new byte[64];
        int ffi_return = Native.profileKeyGetProfileKeyVersionJNI(this.contents, UUIDUtil.serialize(uuid), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyVersion(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

