/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.groups;

import java.security.SecureRandom;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.groups.GroupMasterKey;
import org.signal.zkgroup.groups.GroupPublicParams;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;

public final class GroupSecretParams
extends ByteArray {
    public static final int SIZE = 289;

    public static GroupSecretParams generate() {
        return GroupSecretParams.generate(new SecureRandom());
    }

    public static GroupSecretParams generate(SecureRandom secureRandom) {
        byte[] newContents = new byte[289];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.groupSecretParamsGenerateDeterministicJNI(random, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new GroupSecretParams(newContents);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GroupSecretParams deriveFromMasterKey(GroupMasterKey groupMasterKey) {
        byte[] newContents = new byte[289];
        int ffi_return = Native.groupSecretParamsDeriveFromMasterKeyJNI(groupMasterKey.getInternalContentsForJNI(), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new GroupSecretParams(newContents);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public GroupSecretParams(byte[] contents) {
        super(contents, 289, true);
        int ffi_return = Native.groupSecretParamsCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new IllegalArgumentException(new InvalidInputException("FFI_RETURN_INPUT_ERROR"));
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public GroupMasterKey getMasterKey() {
        byte[] newContents = new byte[32];
        int ffi_return = Native.groupSecretParamsGetMasterKeyJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new GroupMasterKey(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public GroupPublicParams getPublicParams() {
        byte[] newContents = new byte[97];
        int ffi_return = Native.groupSecretParamsGetPublicParamsJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new GroupPublicParams(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

