/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.groups;

import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.groups.GroupIdentifier;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;

public final class GroupPublicParams
extends ByteArray {
    public static final int SIZE = 97;

    public GroupPublicParams(byte[] contents) throws InvalidInputException {
        super(contents, 97);
        int ffi_return = Native.groupPublicParamsCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new InvalidInputException("FFI_RETURN_INPUT_ERROR");
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public GroupIdentifier getGroupIdentifier() {
        byte[] newContents = new byte[32];
        int ffi_return = Native.groupPublicParamsGetGroupIdentifierJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new GroupIdentifier(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

