/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.auth;

import java.security.SecureRandom;
import java.util.UUID;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ServerPublicParams;
import org.signal.zkgroup.VerificationFailedException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.auth.AuthCredential;
import org.signal.zkgroup.auth.AuthCredentialPresentation;
import org.signal.zkgroup.auth.AuthCredentialResponse;
import org.signal.zkgroup.groups.GroupSecretParams;
import org.signal.zkgroup.internal.Native;
import org.signal.zkgroup.util.UUIDUtil;

public class ClientZkAuthOperations {
    private final ServerPublicParams serverPublicParams;

    public ClientZkAuthOperations(ServerPublicParams serverPublicParams) {
        this.serverPublicParams = serverPublicParams;
    }

    public AuthCredential receiveAuthCredential(UUID uuid, int redemptionTime, AuthCredentialResponse authCredentialResponse) throws VerificationFailedException {
        byte[] newContents = new byte[342];
        int ffi_return = Native.serverPublicParamsReceiveAuthCredentialJNI(this.serverPublicParams.getInternalContentsForJNI(), UUIDUtil.serialize(uuid), redemptionTime, authCredentialResponse.getInternalContentsForJNI(), newContents);
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new AuthCredential(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public AuthCredentialPresentation createAuthCredentialPresentation(GroupSecretParams groupSecretParams, AuthCredential authCredential) {
        return this.createAuthCredentialPresentation(new SecureRandom(), groupSecretParams, authCredential);
    }

    public AuthCredentialPresentation createAuthCredentialPresentation(SecureRandom secureRandom, GroupSecretParams groupSecretParams, AuthCredential authCredential) {
        byte[] newContents = new byte[493];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.serverPublicParamsCreateAuthCredentialPresentationDeterministicJNI(this.serverPublicParams.getInternalContentsForJNI(), random, groupSecretParams.getInternalContentsForJNI(), authCredential.getInternalContentsForJNI(), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new AuthCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

