/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.auth;

import java.nio.ByteBuffer;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.groups.UuidCiphertext;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;

public final class AuthCredentialPresentation
extends ByteArray {
    public static final int SIZE = 493;

    public AuthCredentialPresentation(byte[] contents) throws InvalidInputException {
        super(contents, 493);
        int ffi_return = Native.authCredentialPresentationCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new InvalidInputException("FFI_RETURN_INPUT_ERROR");
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public UuidCiphertext getUuidCiphertext() {
        byte[] newContents = new byte[65];
        int ffi_return = Native.authCredentialPresentationGetUuidCiphertextJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getRedemptionTime() {
        byte[] newContents = new byte[4];
        int ffi_return = Native.authCredentialPresentationGetRedemptionTimeJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        return ByteBuffer.wrap(newContents).getInt();
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

