/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup;

import java.security.SecureRandom;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.NotarySignature;
import org.signal.zkgroup.ServerPublicParams;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;

public final class ServerSecretParams
extends ByteArray {
    public static final int SIZE = 769;

    public static ServerSecretParams generate() {
        return ServerSecretParams.generate(new SecureRandom());
    }

    public static ServerSecretParams generate(SecureRandom secureRandom) {
        byte[] newContents = new byte[769];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.serverSecretParamsGenerateDeterministicJNI(random, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ServerSecretParams(newContents);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ServerSecretParams(byte[] contents) {
        super(contents, 769, true);
        int ffi_return = Native.serverSecretParamsCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new IllegalArgumentException(new InvalidInputException("FFI_RETURN_INPUT_ERROR"));
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public ServerPublicParams getPublicParams() {
        byte[] newContents = new byte[161];
        int ffi_return = Native.serverSecretParamsGetPublicParamsJNI(this.contents, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        return new ServerPublicParams(newContents);
    }

    public NotarySignature sign(byte[] message) {
        return this.sign(new SecureRandom(), message);
    }

    public NotarySignature sign(SecureRandom secureRandom, byte[] message) {
        byte[] newContents = new byte[64];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.serverSecretParamsSignDeterministicJNI(this.contents, random, message, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new NotarySignature(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

