/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup;

import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.NotarySignature;
import org.signal.zkgroup.VerificationFailedException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;

public final class ServerPublicParams
extends ByteArray {
    public static final int SIZE = 161;

    public ServerPublicParams(byte[] contents) {
        super(contents, 161, true);
        int ffi_return = Native.serverPublicParamsCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new IllegalArgumentException(new InvalidInputException("FFI_RETURN_INPUT_ERROR"));
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public void verifySignature(byte[] message, NotarySignature notarySignature) throws VerificationFailedException {
        int ffi_return = Native.serverPublicParamsVerifySignatureJNI(this.contents, message, notarySignature.getInternalContentsForJNI());
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

