/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.productivity.java.syslog4j.SyslogConstants;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerConfigIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.SyslogServerMain;
import org.productivity.java.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfig;
import org.productivity.java.syslog4j.server.impl.net.udp.UDPNetSyslogServerConfig;

public class SyslogServer
implements SyslogConstants {
    private static final long serialVersionUID = -2260889360828258602L;
    protected static final Map instances = new Hashtable();

    private SyslogServer() {
    }

    public static final String getVersion() {
        return "Syslog4j 0.9.30 2009-07-25 13:46:57 jpy";
    }

    public static final SyslogServerIF getInstance(String string) throws SyslogRuntimeException {
        String string2 = string.toLowerCase();
        if (instances.containsKey(string2)) {
            return (SyslogServerIF)instances.get(string2);
        }
        throw new SyslogRuntimeException("SyslogServer instance \"" + string2 + "\" not defined; use \"tcp\" or \"udp\" or call SyslogServer.createInstance(protocol,config) first");
    }

    public static final SyslogServerIF getThreadedInstance(String string) throws SyslogRuntimeException {
        SyslogServerIF syslogServerIF = SyslogServer.getInstance(string);
        if (syslogServerIF.getThread() == null) {
            Thread thread = new Thread(syslogServerIF);
            thread.setName("SyslogServer: " + string);
            syslogServerIF.setThread(thread);
            thread.start();
        }
        return syslogServerIF;
    }

    public static final boolean exists(String string) {
        if (string == null || "".equals(string.trim())) {
            return false;
        }
        return instances.containsKey(string.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SyslogServerIF createInstance(String string, SyslogServerConfigIF syslogServerConfigIF) throws SyslogRuntimeException {
        if (string == null || "".equals(string.trim())) {
            throw new SyslogRuntimeException("Instance protocol cannot be null or empty");
        }
        if (syslogServerConfigIF == null) {
            throw new SyslogRuntimeException("SyslogServerConfig cannot be null");
        }
        String string2 = string.toLowerCase();
        SyslogServerIF syslogServerIF = null;
        Map map = instances;
        synchronized (map) {
            if (instances.containsKey(string2)) {
                throw new SyslogRuntimeException("SyslogServer instance \"" + string2 + "\" already defined.");
            }
            try {
                Class clazz = syslogServerConfigIF.getSyslogServerClass();
                syslogServerIF = (SyslogServerIF)clazz.newInstance();
            }
            catch (ClassCastException classCastException) {
                throw new SyslogRuntimeException(classCastException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SyslogRuntimeException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new SyslogRuntimeException(instantiationException);
            }
            syslogServerIF.initialize(string2, syslogServerConfigIF);
            instances.put(string2, syslogServerIF);
        }
        return syslogServerIF;
    }

    public static final SyslogServerIF createThreadedInstance(String string, SyslogServerConfigIF syslogServerConfigIF) throws SyslogRuntimeException {
        SyslogServer.createInstance(string, syslogServerConfigIF);
        SyslogServerIF syslogServerIF = SyslogServer.getThreadedInstance(string);
        return syslogServerIF;
    }

    public static synchronized void initialize() {
        SyslogServer.createInstance("udp", new UDPNetSyslogServerConfig());
        SyslogServer.createInstance("tcp", new TCPNetSyslogServerConfig());
    }

    public static final synchronized void shutdown() throws SyslogRuntimeException {
        Set set = instances.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SyslogServerIF syslogServerIF = (SyslogServerIF)instances.get(string);
            syslogServerIF.shutdown();
        }
        instances.clear();
    }

    public static void main(String[] stringArray) throws Exception {
        SyslogServerMain.main(stringArray);
    }

    static {
        SyslogServer.initialize();
    }
}

