/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl;

import java.util.ArrayList;
import java.util.List;
import org.productivity.java.syslog4j.SyslogBackLogHandlerIF;
import org.productivity.java.syslog4j.SyslogMessageModifierIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslogConfigIF;
import org.productivity.java.syslog4j.impl.backlog.printstream.SystemErrSyslogBackLogHandler;
import org.productivity.java.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslogConfig
implements AbstractSyslogConfigIF {
    private static final long serialVersionUID = -3728308557871358111L;
    protected static final List defaultBackLogHandlers = new ArrayList();
    protected int facility = 8;
    protected String charSet = "UTF-8";
    protected String ident = "";
    protected boolean sendLocalTimestamp = true;
    protected boolean sendLocalName = true;
    protected boolean includeIdentInMessageModifier = false;
    protected boolean throwExceptionOnWrite = false;
    protected boolean throwExceptionOnInitialize = true;
    protected int maxMessageLength = 1024;
    protected byte[] splitMessageBeginText = "...".getBytes();
    protected byte[] splitMessageEndText = "...".getBytes();
    protected List messageModifiers = null;
    protected List backLogHandlers = null;
    protected boolean threaded = true;
    protected long threadLoopInterval = 500L;
    protected int writeRetries = 2;
    protected int maxShutdownWait = 30000;
    protected boolean truncateMessage = false;
    protected boolean useStructuredData = false;

    public abstract Class getSyslogClass();

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }

    public boolean isThrowExceptionOnWrite() {
        return this.throwExceptionOnWrite;
    }

    public void setThrowExceptionOnWrite(boolean bl) {
        this.throwExceptionOnWrite = bl;
    }

    public boolean isThrowExceptionOnInitialize() {
        return this.throwExceptionOnInitialize;
    }

    public void setThrowExceptionOnInitialize(boolean bl) {
        this.throwExceptionOnInitialize = bl;
    }

    public byte[] getSplitMessageBeginText() {
        return this.splitMessageBeginText;
    }

    public void setSplitMessageBeginText(byte[] byArray) {
        this.splitMessageBeginText = byArray;
    }

    public void setSplitMessageBeginText(String string) throws SyslogRuntimeException {
        this.splitMessageBeginText = SyslogUtility.getBytes(this, string);
    }

    public byte[] getSplitMessageEndText() {
        return this.splitMessageEndText;
    }

    public void setSplitMessageEndText(byte[] byArray) {
        this.splitMessageEndText = byArray;
    }

    public void setSplitMessageEndText(String string) throws SyslogRuntimeException {
        this.splitMessageEndText = SyslogUtility.getBytes(this, string);
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(int n) {
        this.maxMessageLength = n;
    }

    public boolean isSendLocalTimestamp() {
        return this.sendLocalTimestamp;
    }

    public void setSendLocalTimestamp(boolean bl) {
        this.sendLocalTimestamp = bl;
    }

    public boolean isSendLocalName() {
        return this.sendLocalName;
    }

    public void setSendLocalName(boolean bl) {
        this.sendLocalName = bl;
    }

    public int getFacility() {
        return this.facility;
    }

    public void setFacility(int n) {
        this.facility = n;
    }

    public void setFacility(String string) {
        this.facility = SyslogUtility.getFacility(string);
    }

    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String string) {
        this.ident = string;
    }

    protected synchronized List _getMessageModifiers() {
        if (this.messageModifiers == null) {
            this.messageModifiers = new ArrayList();
        }
        return this.messageModifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageModifier(SyslogMessageModifierIF syslogMessageModifierIF) {
        List list;
        if (syslogMessageModifierIF == null) {
            return;
        }
        List list2 = list = this._getMessageModifiers();
        synchronized (list2) {
            list.add(syslogMessageModifierIF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMessageModifier(int n, SyslogMessageModifierIF syslogMessageModifierIF) {
        List list;
        if (syslogMessageModifierIF == null) {
            return;
        }
        List list2 = list = this._getMessageModifiers();
        synchronized (list2) {
            try {
                list.add(n, syslogMessageModifierIF);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new SyslogRuntimeException(indexOutOfBoundsException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageModifier(SyslogMessageModifierIF syslogMessageModifierIF) {
        List list;
        if (syslogMessageModifierIF == null) {
            return;
        }
        List list2 = list = this._getMessageModifiers();
        synchronized (list2) {
            list.remove(syslogMessageModifierIF);
        }
    }

    public List getMessageModifiers() {
        return this.messageModifiers;
    }

    public void setMessageModifiers(List list) {
        this.messageModifiers = list;
    }

    public void removeAllMessageModifiers() {
        if (this.messageModifiers == null || this.messageModifiers.isEmpty()) {
            return;
        }
        this.messageModifiers.clear();
    }

    protected synchronized List _getBackLogHandlers() {
        if (this.backLogHandlers == null) {
            this.backLogHandlers = new ArrayList();
        }
        return this.backLogHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackLogHandler(SyslogBackLogHandlerIF syslogBackLogHandlerIF) {
        List list;
        if (syslogBackLogHandlerIF == null) {
            return;
        }
        List list2 = list = this._getBackLogHandlers();
        synchronized (list2) {
            list.add(syslogBackLogHandlerIF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBackLogHandler(int n, SyslogBackLogHandlerIF syslogBackLogHandlerIF) {
        List list;
        if (syslogBackLogHandlerIF == null) {
            return;
        }
        List list2 = list = this._getBackLogHandlers();
        synchronized (list2) {
            try {
                list.add(n, syslogBackLogHandlerIF);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new SyslogRuntimeException(indexOutOfBoundsException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBackLogHandler(SyslogBackLogHandlerIF syslogBackLogHandlerIF) {
        List list;
        if (syslogBackLogHandlerIF == null) {
            return;
        }
        List list2 = list = this._getBackLogHandlers();
        synchronized (list2) {
            list.remove(syslogBackLogHandlerIF);
        }
    }

    public List getBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.size() < 1) {
            return defaultBackLogHandlers;
        }
        return this.backLogHandlers;
    }

    public void setBackLogHandlers(List list) {
        this.backLogHandlers = list;
    }

    public void removeAllBackLogHandlers() {
        if (this.backLogHandlers == null || this.backLogHandlers.isEmpty()) {
            return;
        }
        this.backLogHandlers.clear();
    }

    public boolean isIncludeIdentInMessageModifier() {
        return this.includeIdentInMessageModifier;
    }

    public void setIncludeIdentInMessageModifier(boolean bl) {
        this.includeIdentInMessageModifier = bl;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public void setThreaded(boolean bl) {
        this.threaded = bl;
    }

    public long getThreadLoopInterval() {
        return this.threadLoopInterval;
    }

    public void setThreadLoopInterval(long l) {
        this.threadLoopInterval = l;
    }

    public int getMaxShutdownWait() {
        return this.maxShutdownWait;
    }

    public void setMaxShutdownWait(int n) {
        this.maxShutdownWait = n;
    }

    public int getWriteRetries() {
        return this.writeRetries;
    }

    public void setWriteRetries(int n) {
        this.writeRetries = n;
    }

    public boolean isTruncateMessage() {
        return this.truncateMessage;
    }

    public void setTruncateMessage(boolean bl) {
        this.truncateMessage = bl;
    }

    public boolean isUseStructuredData() {
        return this.useStructuredData;
    }

    public void setUseStructuredData(boolean bl) {
        this.useStructuredData = bl;
    }

    public Class getSyslogWriterClass() {
        return null;
    }

    static {
        defaultBackLogHandlers.add(new SystemErrSyslogBackLogHandler());
    }
}

