/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.basic;

import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.basic.BasicCredentials;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;

@Priority(value=1000)
public class BasicCredentialAuthFilter<P extends Principal>
extends AuthFilter<BasicCredentials, P> {
    private BasicCredentialAuthFilter() {
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        BasicCredentials credentials = this.getCredentials((String)requestContext.getHeaders().getFirst((Object)"Authorization"));
        if (!this.authenticate(requestContext, credentials, "BASIC")) {
            throw new WebApplicationException(this.unauthorizedHandler.buildResponse(this.prefix, this.realm));
        }
    }

    @Nullable
    private BasicCredentials getCredentials(String header) {
        String decoded;
        if (header == null) {
            return null;
        }
        int space = header.indexOf(32);
        if (space <= 0) {
            return null;
        }
        String method = header.substring(0, space);
        if (!this.prefix.equalsIgnoreCase(method)) {
            return null;
        }
        try {
            decoded = new String(Base64.getDecoder().decode(header.substring(space + 1)), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Error decoding credentials", (Throwable)e);
            return null;
        }
        int i = decoded.indexOf(58);
        if (i <= 0) {
            return null;
        }
        String username = decoded.substring(0, i);
        String password = decoded.substring(i + 1);
        return new BasicCredentials(username, password);
    }

    public static class Builder<P extends Principal>
    extends AuthFilter.AuthFilterBuilder<BasicCredentials, P, BasicCredentialAuthFilter<P>> {
        @Override
        protected BasicCredentialAuthFilter<P> newInstance() {
            return new BasicCredentialAuthFilter();
        }
    }
}

