/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.event.structured;

import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.productivity.java.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.productivity.java.syslog4j.server.impl.event.SyslogServerEvent;

public class StructuredSyslogServerEvent
extends SyslogServerEvent {
    private static final long serialVersionUID = 1676499796406044315L;
    private String applicationName = "unknown";
    private String processId = null;

    public StructuredSyslogServerEvent(byte[] byArray, int n, InetAddress inetAddress) {
        super(byArray, n, inetAddress);
    }

    protected void parseApplicationName() {
        int n = this.message.indexOf(32);
        if (n > -1) {
            this.applicationName = this.message.substring(0, n).trim();
            this.message = this.message.substring(n + 1);
            this.parseProcessId();
        }
        if ("-".equals(this.applicationName)) {
            this.applicationName = null;
        }
    }

    protected void parseProcessId() {
        int n = this.message.indexOf(32);
        if (n > -1) {
            this.processId = this.message.substring(0, n).trim();
            this.message = this.message.substring(n + 1);
        }
        if ("-".equals(this.processId)) {
            this.processId = null;
        }
    }

    protected void parseDate() {
        int n = this.message.indexOf(32);
        this.message = this.message.substring(n + 1);
        n = this.message.indexOf(32);
        if (n > -1) {
            String string = this.message.substring(0, n).trim();
            if (string.length() == 25 && string.lastIndexOf(58) == 22) {
                String string2 = string.substring(0, 22) + string.substring(23, 25);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
                try {
                    this.date = simpleDateFormat.parse(string2);
                }
                catch (ParseException parseException) {
                    this.date = new Date();
                }
                this.message = this.message.substring(n + 1);
            } else {
                super.parseDate();
                return;
            }
        }
        this.parseHost();
    }

    protected void parseHost() {
        int n = this.message.indexOf(32);
        if (n > -1) {
            this.host = this.message.substring(0, n).trim();
            this.message = this.message.substring(n + 1);
        }
        if ("-".equals(this.host)) {
            this.host = null;
        }
        this.parseApplicationName();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public StructuredSyslogMessage getStructuredMessage() {
        try {
            return StructuredSyslogMessage.fromString(this.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new StructuredSyslogMessage(null, null, this.getMessage());
        }
    }
}

