/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogConstants;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogMain;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.net.tcp.TCPNetSyslogConfig;
import org.productivity.java.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import org.productivity.java.syslog4j.impl.unix.UnixSyslogConfig;
import org.productivity.java.syslog4j.impl.unix.socket.UnixSocketSyslogConfig;
import org.productivity.java.syslog4j.util.OSDetectUtility;
import org.productivity.java.syslog4j.util.SyslogUtility;

public final class Syslog
implements SyslogConstants {
    private static final long serialVersionUID = -4662318148650646144L;
    protected static final Map instances = new Hashtable();

    private Syslog() {
    }

    public static final String getVersion() {
        return "Syslog4j 0.9.30 2009-07-25 13:46:57 jpy";
    }

    public static final SyslogIF getInstance(String string) throws SyslogRuntimeException {
        String string2 = string.toLowerCase();
        if (instances.containsKey(string2)) {
            return (SyslogIF)instances.get(string2);
        }
        StringBuffer stringBuffer = new StringBuffer("Syslog protocol \"" + string + "\" not defined; call Syslogger.createSyslogInstance(protocol,config) first");
        if (instances.size() > 0) {
            stringBuffer.append(" or use one of the following instances: ");
            Iterator iterator = instances.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                stringBuffer.append(string3);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(' ');
            }
        }
        throw new SyslogRuntimeException(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SyslogIF createInstance(String string, SyslogConfigIF syslogConfigIF) throws SyslogRuntimeException {
        if (string == null || "".equals(string.trim())) {
            throw new SyslogRuntimeException("Instance protocol cannot be null or empty");
        }
        if (syslogConfigIF == null) {
            throw new SyslogRuntimeException("SyslogConfig cannot be null");
        }
        String string2 = string.toLowerCase();
        SyslogIF syslogIF = null;
        Map map = instances;
        synchronized (map) {
            if (instances.containsKey(string2)) {
                throw new SyslogRuntimeException("Syslog protocol \"" + string + "\" already defined");
            }
            try {
                Class clazz = syslogConfigIF.getSyslogClass();
                syslogIF = (SyslogIF)clazz.newInstance();
            }
            catch (ClassCastException classCastException) {
                if (!syslogConfigIF.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(classCastException);
                }
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!syslogConfigIF.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(illegalAccessException);
                }
                return null;
            }
            catch (InstantiationException instantiationException) {
                if (!syslogConfigIF.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(instantiationException);
                }
                return null;
            }
            syslogIF.initialize(string2, syslogConfigIF);
            instances.put(string2, syslogIF);
        }
        return syslogIF;
    }

    public static final synchronized void initialize() {
        Syslog.createInstance("udp", new UDPNetSyslogConfig());
        Syslog.createInstance("tcp", new TCPNetSyslogConfig());
        if (OSDetectUtility.isUnix() && SyslogUtility.isClassExists("com.sun.jna.Native")) {
            Syslog.createInstance("unix_syslog", new UnixSyslogConfig());
            Syslog.createInstance("unix_socket", new UnixSocketSyslogConfig());
        }
    }

    public static final boolean exists(String string) {
        if (string == null || "".equals(string.trim())) {
            return false;
        }
        return instances.containsKey(string.toLowerCase());
    }

    public static final synchronized void shutdown() throws SyslogRuntimeException {
        Set set = instances.keySet();
        Iterator iterator = set.iterator();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SyslogIF syslogIF = (SyslogIF)instances.get(string);
            syslogIF.shutdown();
        }
        instances.clear();
    }

    public static void main(String[] stringArray) throws Exception {
        SyslogMain.main(stringArray);
    }

    static {
        Syslog.initialize();
    }
}

