/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.protobuf.ByteString;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.codec.binary.Hex;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.storage.Table;
import org.signal.storageservice.storage.protos.contacts.StorageItem;

public class StorageItemsTable
extends Table {
    public static final String FAMILY = "c";
    public static final String ROW_KEY = "contact";
    public static final String COLUMN_DATA = "d";
    public static final String COLUMN_KEY = "k";
    private final MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)"storage_metrics");
    private final Timer getTimer = this.metricRegistry.timer(MetricRegistry.name(StorageItemsTable.class, (String[])new String[]{"get"}));
    private final Timer setTimer = this.metricRegistry.timer(MetricRegistry.name(StorageItemsTable.class, (String[])new String[]{"create"}));
    private final Timer getKeysToDeleteTimer = this.metricRegistry.timer(MetricRegistry.name(StorageItemsTable.class, (String[])new String[]{"getKeysToDelete"}));
    private final Timer deleteKeysTimer = this.metricRegistry.timer(MetricRegistry.name(StorageItemsTable.class, (String[])new String[]{"deleteKeys"}));

    public StorageItemsTable(BigtableDataClient client, String tableId) {
        super(client, tableId);
    }

    public CompletableFuture<Void> set(User user, List<StorageItem> inserts, List<ByteString> deletes) {
        BulkMutation bulkMutation = BulkMutation.create((String)this.tableId);
        for (StorageItem insert : inserts) {
            bulkMutation.add(this.getRowKeyFor(user, insert.getKey()), Mutation.create().setCell(FAMILY, ByteString.copyFromUtf8((String)COLUMN_DATA), 0L, insert.getValue()).setCell(FAMILY, ByteString.copyFromUtf8((String)COLUMN_KEY), 0L, insert.getKey()));
        }
        for (ByteString delete : deletes) {
            bulkMutation.add(this.getRowKeyFor(user, delete), Mutation.create().deleteRow());
        }
        return StorageItemsTable.toFuture(this.client.bulkMutateRowsAsync(bulkMutation), this.setTimer);
    }

    public CompletableFuture<Void> clear(User user) {
        Query query = Query.create((String)this.tableId);
        query.prefix(this.getRowKeyPrefixFor(user));
        final Timer.Context getKeysContext = this.getKeysToDeleteTimer.time();
        final CompletableFuture future = new CompletableFuture();
        this.client.readRowsAsync(query, (ResponseObserver)new ResponseObserver<Row>(){
            private final List<ByteString> keys = new LinkedList<ByteString>();

            public void onStart(StreamController streamController) {
            }

            public void onResponse(Row row) {
                this.keys.add(row.getKey());
            }

            public void onError(Throwable throwable) {
                getKeysContext.close();
                future.completeExceptionally(throwable);
            }

            public void onComplete() {
                getKeysContext.close();
                future.complete(this.keys);
            }
        });
        return future.thenCompose(keysToDelete -> {
            if (keysToDelete.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            BulkMutation bulkMutation = BulkMutation.create((String)this.tableId);
            for (ByteString key : keysToDelete) {
                bulkMutation.add(key, Mutation.create().deleteRow());
            }
            return StorageItemsTable.toFuture(this.client.bulkMutateRowsAsync(bulkMutation), this.deleteKeysTimer);
        });
    }

    public CompletableFuture<List<StorageItem>> get(User user, List<ByteString> keys) {
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("No keys");
        }
        final Timer.Context timerContext = this.getTimer.time();
        final CompletableFuture<List<StorageItem>> future = new CompletableFuture<List<StorageItem>>();
        final LinkedList results = new LinkedList();
        Query query = Query.create((String)this.tableId);
        for (ByteString key : keys) {
            query.rowKey(this.getRowKeyFor(user, key));
        }
        this.client.readRowsAsync(query, (ResponseObserver)new ResponseObserver<Row>(){

            public void onStart(StreamController controller) {
            }

            public void onResponse(Row row) {
                ByteString key = row.getCells().stream().filter(cell -> StorageItemsTable.COLUMN_KEY.equals(cell.getQualifier().toStringUtf8())).findFirst().orElseThrow().getValue();
                ByteString value = row.getCells().stream().filter(cell -> StorageItemsTable.COLUMN_DATA.equals(cell.getQualifier().toStringUtf8())).findFirst().orElseThrow().getValue();
                results.add(StorageItem.newBuilder().setKey(key).setValue(value).build());
            }

            public void onError(Throwable t) {
                timerContext.close();
                future.completeExceptionally(t);
            }

            public void onComplete() {
                timerContext.close();
                future.complete(results);
            }
        });
        return future;
    }

    private ByteString getRowKeyFor(User user, ByteString key) {
        return ByteString.copyFromUtf8((String)(user.getUuid().toString() + "#contact#" + Hex.encodeHexString((byte[])key.toByteArray())));
    }

    private ByteString getRowKeyPrefixFor(User user) {
        return ByteString.copyFromUtf8((String)(user.getUuid().toString() + "#contact#"));
    }
}

