/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.storage.GroupLogTable;
import org.signal.storageservice.storage.GroupsTable;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupChanges;

public class GroupsManager {
    private final GroupsTable groupsTable;
    private final GroupLogTable groupLogTable;

    public GroupsManager(BigtableDataClient client, String groupsTableId, String groupLogsTableId) {
        this.groupsTable = new GroupsTable(client, groupsTableId);
        this.groupLogTable = new GroupLogTable(client, groupLogsTableId);
    }

    public CompletableFuture<Optional<Group>> getGroup(ByteString groupId) {
        return this.groupsTable.getGroup(groupId);
    }

    public CompletableFuture<Boolean> createGroup(ByteString groupId, Group group) {
        return this.groupsTable.createGroup(groupId, group);
    }

    public CompletableFuture<Optional<Group>> updateGroup(ByteString groupId, Group group) {
        return this.groupsTable.updateGroup(groupId, group).thenCompose(modified -> {
            if (modified.booleanValue()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return this.getGroup(groupId).thenApply(result -> Optional.of((Group)result.orElseThrow()));
        });
    }

    public CompletableFuture<List<GroupChanges.GroupChangeState>> getChangeRecords(ByteString groupId, int fromVersionInclusive, int toVersionExclusive) {
        return this.groupLogTable.getRecordsFromVersion(groupId, fromVersionInclusive, toVersionExclusive);
    }

    public CompletableFuture<Boolean> appendChangeRecord(ByteString groupId, int version, GroupChange change, Group state) {
        return this.groupLogTable.append(groupId, version, change, state);
    }
}

