/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.metrics;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.dropwizard.validation.PortRange;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.net.tcp.ssl.SSLTCPNetSyslogConfig;

@JsonTypeName(value="papertrail")
public class LoggingNetworkAppenderFactory
extends AbstractAppenderFactory<ILoggingEvent> {
    @JsonProperty
    @NotEmpty
    private String ident;
    @JsonProperty
    @NotEmpty
    private String host;
    @JsonProperty
    @PortRange(min=1)
    @NotNull
    private @PortRange(min=1) @NotNull Integer port;
    @JsonProperty
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @JsonProperty
    @NotEmpty
    private String facility = "USER";
    @JsonProperty
    private boolean sendLocalName = true;

    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public boolean isSendLocalName() {
        return this.sendLocalName;
    }

    public void setSendLocalName(boolean sendLocalName) {
        this.sendLocalName = sendLocalName;
    }

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, LayoutFactory<ILoggingEvent> layoutFactory, LevelFilterFactory<ILoggingEvent> levelFilterFactory, AsyncAppenderFactory<ILoggingEvent> asyncAppenderFactory) {
        Syslog4jAppender syslogAppender = new Syslog4jAppender();
        syslogAppender.setContext((Context)context);
        syslogAppender.setLayout(this.buildLayout(context, layoutFactory));
        syslogAppender.setName("SYSLOG-TLS");
        SSLTCPNetSyslogConfig syslogConfig = new SSLTCPNetSyslogConfig();
        syslogConfig.setIdent(this.ident);
        syslogConfig.setHost(this.host);
        syslogConfig.setPort(this.port.intValue());
        syslogConfig.setFacility(this.facility);
        syslogConfig.setSendLocalName(this.sendLocalName);
        syslogAppender.setSyslogConfig((SyslogConfigIF)syslogConfig);
        syslogAppender.addFilter(levelFilterFactory.build(this.threshold));
        syslogAppender.start();
        return syslogAppender;
    }

    private static class Syslog4jAppender<E>
    extends AppenderBase<E> {
        SyslogIF syslog;
        SyslogConfigIF syslogConfig;
        Layout<E> layout;

        private Syslog4jAppender() {
        }

        protected void append(E loggingEvent) {
            this.syslog.log(this.getSeverityForEvent(loggingEvent), this.layout.doLayout(loggingEvent));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            super.start();
            Syslog4jAppender syslog4jAppender = this;
            synchronized (syslog4jAppender) {
                try {
                    Class syslogClass = this.syslogConfig.getSyslogClass();
                    this.syslog = (SyslogIF)syslogClass.newInstance();
                    this.syslog.initialize(syslogClass.getSimpleName(), this.syslogConfig);
                }
                catch (ClassCastException | IllegalAccessException | InstantiationException cse) {
                    throw new SyslogRuntimeException((Throwable)cse);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            super.stop();
            Syslog4jAppender syslog4jAppender = this;
            synchronized (syslog4jAppender) {
                if (this.syslog != null) {
                    this.syslog.shutdown();
                    this.syslog = null;
                }
            }
        }

        public int getSeverityForEvent(Object eventObject) {
            if (eventObject instanceof ILoggingEvent) {
                ILoggingEvent event = (ILoggingEvent)eventObject;
                return LevelToSyslogSeverity.convert((ILoggingEvent)event);
            }
            return 6;
        }

        public SyslogConfigIF getSyslogConfig() {
            return this.syslogConfig;
        }

        public void setSyslogConfig(SyslogConfigIF syslogConfig) {
            this.syslogConfig = syslogConfig;
        }

        public Layout<E> getLayout() {
            return this.layout;
        }

        public void setLayout(Layout<E> layout) {
            this.layout = layout;
        }
    }
}

