/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.auth;

import com.google.protobuf.ByteString;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;
import java.util.Optional;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.signal.storageservice.auth.GroupUser;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.InvalidRedemptionTimeException;
import org.signal.zkgroup.VerificationFailedException;
import org.signal.zkgroup.auth.AuthCredentialPresentation;
import org.signal.zkgroup.auth.ServerZkAuthOperations;
import org.signal.zkgroup.groups.GroupPublicParams;

public class GroupUserAuthenticator
implements Authenticator<BasicCredentials, GroupUser> {
    private ServerZkAuthOperations serverZkAuthOperations;

    public GroupUserAuthenticator(ServerZkAuthOperations serverZkAuthOperations) {
        this.serverZkAuthOperations = serverZkAuthOperations;
    }

    public Optional<GroupUser> authenticate(BasicCredentials basicCredentials) {
        try {
            String encodedGroupPublicKey = basicCredentials.getUsername();
            String encodedPresentation = basicCredentials.getPassword();
            GroupPublicParams groupPublicKey = new GroupPublicParams(Hex.decodeHex((String)encodedGroupPublicKey));
            AuthCredentialPresentation presentation = new AuthCredentialPresentation(Hex.decodeHex((String)encodedPresentation));
            this.serverZkAuthOperations.verifyAuthCredentialPresentation(groupPublicKey, presentation);
            return Optional.of(new GroupUser(ByteString.copyFrom((byte[])presentation.getUuidCiphertext().serialize()), ByteString.copyFrom((byte[])groupPublicKey.serialize()), ByteString.copyFrom((byte[])groupPublicKey.getGroupIdentifier().serialize())));
        }
        catch (DecoderException | InvalidInputException | InvalidRedemptionTimeException | VerificationFailedException e) {
            return Optional.empty();
        }
    }
}

