/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.auth;

import com.google.protobuf.ByteString;
import java.security.MessageDigest;
import java.security.Principal;
import javax.security.auth.Subject;
import org.signal.storageservice.storage.protos.groups.Member;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.groups.GroupPublicParams;

public class GroupUser
implements Principal {
    private final ByteString userCiphertext;
    private final ByteString groupPublicKey;
    private final ByteString groupId;

    GroupUser(ByteString userCiphertext, ByteString groupPublicKey, ByteString groupId) {
        this.userCiphertext = userCiphertext;
        this.groupPublicKey = groupPublicKey;
        this.groupId = groupId;
    }

    public boolean isMember(Member member, ByteString groupPublicKey) {
        return this.isMember(member.getUserId(), groupPublicKey);
    }

    public boolean isMember(ByteString uuid, ByteString groupPublicKey) {
        return MessageDigest.isEqual(this.groupPublicKey.toByteArray(), groupPublicKey.toByteArray()) && MessageDigest.isEqual(this.userCiphertext.toByteArray(), uuid.toByteArray());
    }

    public GroupPublicParams getGroupPublicKey() {
        try {
            return new GroupPublicParams(this.groupPublicKey.toByteArray());
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ByteString getGroupId() {
        return this.groupId;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean implies(Subject subject) {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof GroupUser)) {
            return false;
        }
        GroupUser that = (GroupUser)other;
        return this.userCiphertext.equals((Object)that.userCiphertext) && this.groupPublicKey.equals((Object)that.groupPublicKey);
    }

    @Override
    public int hashCode() {
        return this.userCiphertext.hashCode() ^ this.groupPublicKey.hashCode();
    }
}

