/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.Application;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.PolymorphicAuthDynamicFeature;
import io.dropwizard.auth.PolymorphicAuthValueFactoryProvider;
import io.dropwizard.auth.basic.BasicCredentialAuthFilter;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.signal.storageservice.StorageServiceConfiguration;
import org.signal.storageservice.auth.ExternalGroupCredentialGenerator;
import org.signal.storageservice.auth.ExternalServiceCredentialValidator;
import org.signal.storageservice.auth.GroupUser;
import org.signal.storageservice.auth.GroupUserAuthenticator;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.auth.UserAuthenticator;
import org.signal.storageservice.controllers.BackupsController;
import org.signal.storageservice.controllers.GroupsController;
import org.signal.storageservice.controllers.HealthCheckController;
import org.signal.storageservice.controllers.StorageController;
import org.signal.storageservice.metrics.CpuUsageGauge;
import org.signal.storageservice.metrics.FileDescriptorGauge;
import org.signal.storageservice.metrics.FreeMemoryGauge;
import org.signal.storageservice.metrics.NetworkReceivedGauge;
import org.signal.storageservice.metrics.NetworkSentGauge;
import org.signal.storageservice.providers.CompletionExceptionMapper;
import org.signal.storageservice.providers.InvalidProtocolBufferExceptionMapper;
import org.signal.storageservice.providers.ProtocolBufferMessageBodyProvider;
import org.signal.storageservice.providers.ProtocolBufferValidationErrorMessageBodyWriter;
import org.signal.storageservice.s3.PolicySigner;
import org.signal.storageservice.s3.PostPolicyGenerator;
import org.signal.storageservice.storage.BackupsManager;
import org.signal.storageservice.storage.GroupsManager;
import org.signal.storageservice.storage.StorageManager;
import org.signal.zkgroup.ServerSecretParams;
import org.signal.zkgroup.auth.ServerZkAuthOperations;

public class StorageService
extends Application<StorageServiceConfiguration> {
    public void initialize(Bootstrap<StorageServiceConfiguration> bootstrap) {
    }

    public void run(StorageServiceConfiguration config, Environment environment) throws Exception {
        SharedMetricRegistries.add((String)"storage_metrics", (MetricRegistry)environment.metrics());
        BigtableTableAdminSettings bigtableTableAdminSettings = BigtableTableAdminSettings.newBuilder().setProjectId(config.getBigTableConfiguration().getProjectId()).setInstanceId(config.getBigTableConfiguration().getInstanceId()).build();
        BigtableTableAdminClient bigtableTableAdminClient = BigtableTableAdminClient.create((BigtableTableAdminSettings)bigtableTableAdminSettings);
        BigtableDataSettings bigtableDataSettings = BigtableDataSettings.newBuilder().setProjectId(config.getBigTableConfiguration().getProjectId()).setInstanceId(config.getBigTableConfiguration().getInstanceId()).build();
        BigtableDataClient bigtableDataClient = BigtableDataClient.create((BigtableDataSettings)bigtableDataSettings);
        ServerSecretParams serverSecretParams = new ServerSecretParams(config.getZkConfiguration().getServerSecret());
        StorageManager storageManager = new StorageManager(bigtableDataClient, config.getBigTableConfiguration().getContactManifestsTableId(), config.getBigTableConfiguration().getContactsTableId());
        GroupsManager groupsManager = new GroupsManager(bigtableDataClient, config.getBigTableConfiguration().getGroupsTableId(), config.getBigTableConfiguration().getGroupLogsTableId());
        BackupsManager backupsManager = new BackupsManager(bigtableTableAdminClient, config.getBigTableConfiguration().getClusterId(), List.of(config.getBigTableConfiguration().getContactManifestsTableId(), config.getBigTableConfiguration().getContactsTableId(), config.getBigTableConfiguration().getGroupLogsTableId(), config.getBigTableConfiguration().getGroupsTableId()));
        environment.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        environment.getObjectMapper().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        environment.getObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        environment.jersey().register(ProtocolBufferMessageBodyProvider.class);
        environment.jersey().register(ProtocolBufferValidationErrorMessageBodyWriter.class);
        environment.jersey().register(InvalidProtocolBufferExceptionMapper.class);
        environment.jersey().register(CompletionExceptionMapper.class);
        UserAuthenticator userAuthenticator = new UserAuthenticator(new ExternalServiceCredentialValidator(config.getAuthenticationConfiguration().getKey()));
        GroupUserAuthenticator groupUserAuthenticator = new GroupUserAuthenticator(new ServerZkAuthOperations(serverSecretParams));
        ExternalGroupCredentialGenerator externalGroupCredentialGenerator = new ExternalGroupCredentialGenerator(config.getGroupConfiguration().getExternalServiceSecret());
        AuthFilter userAuthFilter = new BasicCredentialAuthFilter.Builder().setAuthenticator((Authenticator)userAuthenticator).buildAuthFilter();
        AuthFilter groupUserAuthFilter = new BasicCredentialAuthFilter.Builder().setAuthenticator((Authenticator)groupUserAuthenticator).buildAuthFilter();
        PolicySigner policySigner = new PolicySigner(config.getCdnConfiguration().getAccessSecret(), config.getCdnConfiguration().getRegion());
        PostPolicyGenerator postPolicyGenerator = new PostPolicyGenerator(config.getCdnConfiguration().getRegion(), config.getCdnConfiguration().getBucket(), config.getCdnConfiguration().getAccessKey());
        environment.jersey().register((Object)new PolymorphicAuthDynamicFeature((Map)ImmutableMap.of(User.class, (Object)userAuthFilter, GroupUser.class, (Object)groupUserAuthFilter)));
        environment.jersey().register((Object)new PolymorphicAuthValueFactoryProvider.Binder((Set)ImmutableSet.of(User.class, GroupUser.class)));
        environment.jersey().register((Object)new HealthCheckController());
        environment.jersey().register((Object)new BackupsController(backupsManager));
        environment.jersey().register((Object)new StorageController(storageManager));
        environment.jersey().register((Object)new GroupsController(groupsManager, serverSecretParams, policySigner, postPolicyGenerator, config.getGroupConfiguration().getMaxGroupSize(), externalGroupCredentialGenerator));
        environment.metrics().register(MetricRegistry.name(CpuUsageGauge.class, (String[])new String[]{"cpu"}), (Metric)new CpuUsageGauge());
        environment.metrics().register(MetricRegistry.name(FreeMemoryGauge.class, (String[])new String[]{"free_memory"}), (Metric)new FreeMemoryGauge());
        environment.metrics().register(MetricRegistry.name(NetworkSentGauge.class, (String[])new String[]{"bytes_sent"}), (Metric)new NetworkSentGauge());
        environment.metrics().register(MetricRegistry.name(NetworkReceivedGauge.class, (String[])new String[]{"bytes_received"}), (Metric)new NetworkReceivedGauge());
        environment.metrics().register(MetricRegistry.name(FileDescriptorGauge.class, (String[])new String[]{"fd_count"}), (Metric)new FileDescriptorGauge());
    }

    public static void main(String[] argv) throws Exception {
        new StorageService().run(argv);
    }
}

