/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.util;

public class Conversions {
    public static byte intsToByteHighAndLow(int highValue, int lowValue) {
        return (byte)((highValue << 4 | lowValue) & 0xFF);
    }

    public static int highBitsToInt(byte value) {
        return (value & 0xFF) >> 4;
    }

    public static int lowBitsToInt(byte value) {
        return value & 0xF;
    }

    public static int highBitsToMedium(int value) {
        return value >> 12;
    }

    public static int lowBitsToMedium(int value) {
        return value & 0xFFF;
    }

    public static byte[] shortToByteArray(int value) {
        byte[] bytes = new byte[2];
        Conversions.shortToByteArray(bytes, 0, value);
        return bytes;
    }

    public static int shortToByteArray(byte[] bytes, int offset, int value) {
        bytes[offset + 1] = (byte)value;
        bytes[offset] = (byte)(value >> 8);
        return 2;
    }

    public static int shortToLittleEndianByteArray(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)value;
        bytes[offset + 1] = (byte)(value >> 8);
        return 2;
    }

    public static byte[] mediumToByteArray(int value) {
        byte[] bytes = new byte[3];
        Conversions.mediumToByteArray(bytes, 0, value);
        return bytes;
    }

    public static int mediumToByteArray(byte[] bytes, int offset, int value) {
        bytes[offset + 2] = (byte)value;
        bytes[offset + 1] = (byte)(value >> 8);
        bytes[offset] = (byte)(value >> 16);
        return 3;
    }

    public static byte[] intToByteArray(int value) {
        byte[] bytes = new byte[4];
        Conversions.intToByteArray(bytes, 0, value);
        return bytes;
    }

    public static int intToByteArray(byte[] bytes, int offset, int value) {
        bytes[offset + 3] = (byte)value;
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset] = (byte)(value >> 24);
        return 4;
    }

    public static int intToLittleEndianByteArray(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)value;
        bytes[offset + 1] = (byte)(value >> 8);
        bytes[offset + 2] = (byte)(value >> 16);
        bytes[offset + 3] = (byte)(value >> 24);
        return 4;
    }

    public static byte[] longToByteArray(long l) {
        byte[] bytes = new byte[8];
        Conversions.longToByteArray(bytes, 0, l);
        return bytes;
    }

    public static int longToByteArray(byte[] bytes, int offset, long value) {
        bytes[offset + 7] = (byte)value;
        bytes[offset + 6] = (byte)(value >> 8);
        bytes[offset + 5] = (byte)(value >> 16);
        bytes[offset + 4] = (byte)(value >> 24);
        bytes[offset + 3] = (byte)(value >> 32);
        bytes[offset + 2] = (byte)(value >> 40);
        bytes[offset + 1] = (byte)(value >> 48);
        bytes[offset] = (byte)(value >> 56);
        return 8;
    }

    public static int longTo4ByteArray(byte[] bytes, int offset, long value) {
        bytes[offset + 3] = (byte)value;
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset + 0] = (byte)(value >> 24);
        return 4;
    }

    public static int byteArrayToShort(byte[] bytes) {
        return Conversions.byteArrayToShort(bytes, 0);
    }

    public static int byteArrayToShort(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    public static int byteArrayToMedium(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset + 2] & 0xFF;
    }

    public static int byteArrayToInt(byte[] bytes) {
        return Conversions.byteArrayToInt(bytes, 0);
    }

    public static int byteArrayToInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static int byteArrayToIntLittleEndian(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    public static long byteArrayToLong(byte[] bytes) {
        return Conversions.byteArrayToLong(bytes, 0);
    }

    public static long byteArray4ToLong(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static long byteArrayToLong(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }
}

