/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.codahale.metrics.Timer;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

abstract class Table {
    final BigtableDataClient client;
    final String tableId;

    public Table(BigtableDataClient client, String tableId) {
        this.client = client;
        this.tableId = tableId;
    }

    CompletableFuture<Boolean> setIfValueOrEmpty(Timer timer, ByteString rowId, String columnFamily, String columnName, String columnEquals, Mutation mutation) {
        return this.setIfValue(timer, rowId, columnFamily, columnName, columnEquals, mutation).thenCompose(mutated -> {
            if (mutated.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.setIfEmpty(timer, rowId, columnFamily, columnName, mutation);
        });
    }

    CompletableFuture<Boolean> setIfValue(Timer timer, ByteString rowId, String columnFamily, String columnName, String columnEquals, Mutation mutation) {
        return Table.toFuture(this.client.checkAndMutateRowAsync(ConditionalRowMutation.create((String)this.tableId, (ByteString)rowId).condition((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch(columnFamily)).filter(Filters.FILTERS.qualifier().exactMatch(columnName)).filter(Filters.FILTERS.value().exactMatch(columnEquals))).then(mutation)), timer);
    }

    CompletableFuture<Boolean> setIfEmpty(Timer timer, ByteString rowId, String columnFamily, String columnName, Mutation mutation) {
        return Table.toFuture(this.client.checkAndMutateRowAsync(ConditionalRowMutation.create((String)this.tableId, (ByteString)rowId).condition((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.family().exactMatch(columnFamily)).filter(Filters.FILTERS.qualifier().exactMatch(columnName)).filter(Filters.FILTERS.value().regex("\\C+"))).otherwise(mutation)), timer).thenApply(result -> result == false);
    }

    static <T> CompletableFuture<T> toFuture(ApiFuture<T> future, Timer timer) {
        final Timer.Context timerContext = timer.time();
        final CompletableFuture result = new CompletableFuture();
        ApiFutures.addCallback(future, (ApiFutureCallback)new ApiFutureCallback<T>(){

            public void onFailure(Throwable t) {
                timerContext.close();
                result.completeExceptionally(t);
            }

            public void onSuccess(T t) {
                timerContext.close();
                result.complete(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }
}

