/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.storage.GroupLogTable;
import org.signal.storageservice.storage.GroupsTable;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupChanges;

public class GroupsManager {
    private final GroupsTable groupsTable = new GroupsTable();
    private final GroupLogTable groupLogTable = new GroupLogTable();

    public CompletableFuture<Optional<Group>> getGroup(ByteString groupId) {
        return this.groupsTable.getGroup(groupId);
    }

    public CompletableFuture<Boolean> createGroup(ByteString groupId, Group group) {
        return this.groupsTable.createGroup(groupId, group);
    }

    public CompletableFuture<Optional<Group>> updateGroup(ByteString groupId, Group group) {
        return this.groupsTable.updateGroup(groupId, group).thenCompose(modified -> {
            if (modified.booleanValue()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return this.getGroup(groupId).thenApply(result -> Optional.of((Group)result.orElseThrow()));
        });
    }

    public CompletableFuture<List<GroupChanges.GroupChangeState>> getChangeRecords(ByteString groupId, Group group, int fromVersionInclusive, int toVersionExclusive) {
        if (fromVersionInclusive >= toVersionExclusive) {
            throw new IllegalArgumentException("Version to read from (" + fromVersionInclusive + ") must be less than version to read to (" + toVersionExclusive + ")");
        }
        return this.groupLogTable.getRecordsFromVersion(groupId, fromVersionInclusive, toVersionExclusive).thenApply(groupChangeStates -> {
            if (GroupsManager.isGroupInRange(group, fromVersionInclusive, toVersionExclusive) && GroupsManager.groupVersionMissing(group, groupChangeStates) && toVersionExclusive - 1 == group.getVersion()) {
                groupChangeStates.add(GroupChanges.GroupChangeState.newBuilder().setGroupState(group).build());
            }
            return groupChangeStates;
        });
    }

    public CompletableFuture<Boolean> appendChangeRecord(ByteString groupId, int version, GroupChange change, Group state) {
        return this.groupLogTable.append(groupId, version, change, state);
    }

    private static boolean isGroupInRange(Group group, int fromVersionInclusive, int toVersionExclusive) {
        return fromVersionInclusive <= group.getVersion() && group.getVersion() < toVersionExclusive;
    }

    private static boolean groupVersionMissing(Group group, List<GroupChanges.GroupChangeState> groupChangeStates) {
        return groupChangeStates.stream().noneMatch(groupChangeState -> groupChangeState.getGroupState().getVersion() == group.getVersion());
    }
}

