/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.metrics;

import java.io.IOException;
import org.signal.storageservice.metrics.NetworkGauge;
import org.signal.storageservice.metrics.NetworkSentGauge;
import org.signal.storageservice.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkReceivedGauge
extends NetworkGauge {
    private final Logger logger = LoggerFactory.getLogger(NetworkSentGauge.class);
    private long lastTimestamp;
    private long lastReceived;

    public NetworkReceivedGauge() {
        try {
            this.lastTimestamp = System.currentTimeMillis();
            this.lastReceived = this.getSentReceived().second();
        }
        catch (IOException e) {
            this.logger.warn(NetworkReceivedGauge.class.getSimpleName(), (Throwable)e);
        }
    }

    public Double getValue() {
        try {
            long timestamp = System.currentTimeMillis();
            Pair<Long, Long> sentAndReceived = this.getSentReceived();
            double bytesReceived = sentAndReceived.second() - this.lastReceived;
            double secondsElapsed = (timestamp - this.lastTimestamp) / 1000L;
            double result = bytesReceived / secondsElapsed;
            this.lastTimestamp = timestamp;
            this.lastReceived = sentAndReceived.second();
            return result;
        }
        catch (IOException e) {
            this.logger.warn("NetworkReceivedGauge", (Throwable)e);
            return -1.0;
        }
    }
}

