/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseReporterFactory;
import java.net.UnknownHostException;
import javax.validation.constraints.NotNull;
import org.signal.storageservice.metrics.JsonMetricsReporter;

@JsonTypeName(value="json")
public class JsonMetricsReporterFactory
extends BaseReporterFactory {
    @JsonProperty
    @NotNull
    private String hostname;
    @JsonProperty
    @NotNull
    private String token;
    @JsonProperty
    @NotNull
    private String prefix;

    public ScheduledReporter build(MetricRegistry metricRegistry) {
        try {
            return JsonMetricsReporter.forRegistry(metricRegistry).withHostname(this.hostname).withToken(this.token).withReportingPrefix(this.prefix).convertRatesTo(this.getRateUnit()).convertDurationsTo(this.getDurationUnit()).filter(this.getFilter()).build();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

