/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMetricsReporter
extends ScheduledReporter {
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");
    private final Logger logger = LoggerFactory.getLogger(JsonMetricsReporter.class);
    private final JsonFactory factory = new JsonFactory();
    private final URI uri;
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();

    public JsonMetricsReporter(MetricRegistry registry, String token, String hostname, String reportingPrefix, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) throws UnknownHostException {
        super(registry, "json-reporter", filter, rateUnit, durationUnit);
        this.uri = URI.create(String.format("https://%s/report/metrics?t=%s&h=%s", hostname, token, reportingPrefix + "-" + InetAddress.getLocalHost().getHostName()));
    }

    public void report(SortedMap<String, Gauge> stringGaugeSortedMap, SortedMap<String, Counter> stringCounterSortedMap, SortedMap<String, Histogram> stringHistogramSortedMap, SortedMap<String, Meter> stringMeterSortedMap, SortedMap<String, Timer> stringTimerSortedMap) {
        try {
            this.logger.debug("Reporting metrics...");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonGenerator json = this.factory.createGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
            json.writeStartObject();
            for (Map.Entry<String, Gauge> entry : stringGaugeSortedMap.entrySet()) {
                this.reportGauge(json, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : stringCounterSortedMap.entrySet()) {
                this.reportCounter(json, entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : stringHistogramSortedMap.entrySet()) {
                this.reportHistogram(json, entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : stringMeterSortedMap.entrySet()) {
                this.reportMeter(json, entry.getKey(), (Meter)entry.getValue());
            }
            for (Map.Entry<String, Gauge> entry : stringTimerSortedMap.entrySet()) {
                this.reportTimer(json, entry.getKey(), (Timer)entry.getValue());
            }
            json.writeEndObject();
            json.close();
            outputStream.close();
            HttpRequest request = HttpRequest.newBuilder().uri(this.uri).POST(HttpRequest.BodyPublishers.ofByteArray(outputStream.toByteArray())).header("Content-Type", "application/json").build();
            HttpResponse<Void> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
            this.logger.debug("Metrics server response: " + httpResponse.statusCode());
        }
        catch (IOException e) {
            this.logger.warn("Error sending metrics", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn("error", (Throwable)e);
        }
    }

    private void reportGauge(JsonGenerator json, String name, Gauge gauge) throws IOException {
        Object gaugeValue = this.evaluateGauge(gauge);
        if (gaugeValue instanceof Number) {
            json.writeFieldName(this.sanitize(name));
            json.writeObject(gaugeValue);
        }
    }

    private void reportCounter(JsonGenerator json, String name, Counter counter) throws IOException {
        json.writeFieldName(this.sanitize(name));
        json.writeNumber(counter.getCount());
    }

    private void reportHistogram(JsonGenerator json, String name, Histogram histogram) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        json.writeFieldName(this.sanitize(name));
        json.writeStartObject();
        json.writeNumberField("count", histogram.getCount());
        this.writeSnapshot(json, snapshot);
        json.writeEndObject();
    }

    private void reportMeter(JsonGenerator json, String name, Meter meter) throws IOException {
        json.writeFieldName(this.sanitize(name));
        json.writeStartObject();
        this.writeMetered(json, (Metered)meter);
        json.writeEndObject();
    }

    private void reportTimer(JsonGenerator json, String name, Timer timer) throws IOException {
        json.writeFieldName(this.sanitize(name));
        json.writeStartObject();
        json.writeFieldName("rate");
        json.writeStartObject();
        this.writeMetered(json, (Metered)timer);
        json.writeEndObject();
        json.writeFieldName("duration");
        json.writeStartObject();
        this.writeTimedSnapshot(json, timer.getSnapshot());
        json.writeEndObject();
        json.writeEndObject();
    }

    private Object evaluateGauge(Gauge gauge) {
        try {
            return gauge.getValue();
        }
        catch (RuntimeException e) {
            this.logger.warn("Error reading gauge", (Throwable)e);
            return "error reading gauge";
        }
    }

    private void writeTimedSnapshot(JsonGenerator json, Snapshot snapshot) throws IOException {
        json.writeNumberField("max", this.convertDuration(snapshot.getMax()));
        json.writeNumberField("mean", this.convertDuration(snapshot.getMean()));
        json.writeNumberField("min", this.convertDuration(snapshot.getMin()));
        json.writeNumberField("stddev", this.convertDuration(snapshot.getStdDev()));
        json.writeNumberField("median", this.convertDuration(snapshot.getMedian()));
        json.writeNumberField("p75", this.convertDuration(snapshot.get75thPercentile()));
        json.writeNumberField("p95", this.convertDuration(snapshot.get95thPercentile()));
        json.writeNumberField("p98", this.convertDuration(snapshot.get98thPercentile()));
        json.writeNumberField("p99", this.convertDuration(snapshot.get99thPercentile()));
        json.writeNumberField("p999", this.convertDuration(snapshot.get999thPercentile()));
    }

    private void writeSnapshot(JsonGenerator json, Snapshot snapshot) throws IOException {
        json.writeNumberField("max", snapshot.getMax());
        json.writeNumberField("mean", snapshot.getMean());
        json.writeNumberField("min", snapshot.getMin());
        json.writeNumberField("stddev", snapshot.getStdDev());
        json.writeNumberField("median", snapshot.getMedian());
        json.writeNumberField("p75", snapshot.get75thPercentile());
        json.writeNumberField("p95", snapshot.get95thPercentile());
        json.writeNumberField("p98", snapshot.get98thPercentile());
        json.writeNumberField("p99", snapshot.get99thPercentile());
        json.writeNumberField("p999", snapshot.get999thPercentile());
    }

    private void writeMetered(JsonGenerator json, Metered meter) throws IOException {
        json.writeNumberField("count", this.convertRate(meter.getCount()));
        json.writeNumberField("mean", this.convertRate(meter.getMeanRate()));
        json.writeNumberField("m1", this.convertRate(meter.getOneMinuteRate()));
        json.writeNumberField("m5", this.convertRate(meter.getFiveMinuteRate()));
        json.writeNumberField("m15", this.convertRate(meter.getFifteenMinuteRate()));
    }

    private String sanitize(String metricName) {
        return SIMPLE_NAMES.matcher(metricName).replaceAll("_");
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private MetricFilter filter = MetricFilter.ALL;
        private TimeUnit rateUnit = TimeUnit.SECONDS;
        private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
        private String token;
        private String hostname;
        private String reportingPrefix;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder withReportingPrefix(String reportingPrefix) {
            this.reportingPrefix = reportingPrefix;
            return this;
        }

        public JsonMetricsReporter build() throws UnknownHostException {
            if (this.hostname == null) {
                throw new IllegalArgumentException("No hostname specified!");
            }
            if (this.token == null) {
                throw new IllegalArgumentException("No token specified!");
            }
            return new JsonMetricsReporter(this.registry, this.token, this.hostname, this.reportingPrefix, this.filter, this.rateUnit, this.durationUnit);
        }
    }
}

