/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.controllers;

import com.codahale.metrics.annotation.Timed;
import io.dropwizard.auth.Auth;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.storage.StorageManager;
import org.signal.storageservice.storage.protos.contacts.ReadOperation;
import org.signal.storageservice.storage.protos.contacts.StorageItem;
import org.signal.storageservice.storage.protos.contacts.StorageItems;
import org.signal.storageservice.storage.protos.contacts.StorageManifest;
import org.signal.storageservice.storage.protos.contacts.WriteOperation;

@Path(value="/v1/storage")
public class StorageController {
    private final StorageManager storageManager;

    public StorageController(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Timed
    @GET
    @Path(value="/manifest")
    @Produces(value={"application/x-protobuf"})
    public CompletableFuture<StorageManifest> getManifest(@Auth User user) {
        return this.storageManager.getManifest(user).thenApply(manifest -> (StorageManifest)manifest.orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND)));
    }

    @Timed
    @GET
    @Path(value="/manifest/version/{version}")
    @Produces(value={"application/x-protobuf"})
    public CompletableFuture<StorageManifest> getManifest(@Auth User user, @PathParam(value="version") long version) {
        return this.storageManager.getManifestIfNotVersion(user, version).thenApply(manifest -> (StorageManifest)manifest.orElseThrow(() -> new WebApplicationException(Response.Status.NO_CONTENT)));
    }

    @Timed
    @PUT
    @Consumes(value={"application/x-protobuf"})
    @Produces(value={"application/x-protobuf"})
    public CompletableFuture<Response> write(@Auth User user, WriteOperation writeOperation) {
        if (!writeOperation.hasManifest()) {
            return CompletableFuture.failedFuture((Throwable)new WebApplicationException(Response.Status.BAD_REQUEST));
        }
        CompletableFuture<Object> future = writeOperation.getClearAll() ? this.storageManager.clearItems(user) : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)future.thenCompose(ignored -> this.storageManager.set(user, writeOperation.getManifest(), writeOperation.getInsertItemList(), writeOperation.getDeleteKeyList()))).thenApply(manifest -> {
            if (manifest.isPresent()) {
                return Response.status((int)409).entity(manifest.get()).build();
            }
            return Response.status((int)200).build();
        });
    }

    @Timed
    @PUT
    @Path(value="/read")
    @Consumes(value={"application/x-protobuf"})
    @Produces(value={"application/x-protobuf"})
    public CompletableFuture<StorageItems> read(@Auth User user, ReadOperation readOperation) {
        if (readOperation.getReadKeyList().isEmpty()) {
            return CompletableFuture.failedFuture((Throwable)new WebApplicationException(Response.Status.BAD_REQUEST));
        }
        return this.storageManager.getItems(user, readOperation.getReadKeyList()).thenApply(items -> StorageItems.newBuilder().addAllContacts((Iterable<? extends StorageItem>)items).build());
    }

    @Timed
    @DELETE
    public CompletableFuture<Response> delete(@Auth User user) {
        return this.storageManager.clearItems(user).thenApply(v -> Response.status((Response.Status)Response.Status.OK).build());
    }
}

