/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.auth;

import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;
import java.util.Optional;
import java.util.UUID;
import org.signal.storageservice.auth.ExternalServiceCredentialValidator;
import org.signal.storageservice.auth.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthenticator
implements Authenticator<BasicCredentials, User> {
    private final Logger logger = LoggerFactory.getLogger(UserAuthenticator.class);
    private final ExternalServiceCredentialValidator validator;

    public UserAuthenticator(ExternalServiceCredentialValidator validator) {
        this.validator = validator;
    }

    public Optional<User> authenticate(BasicCredentials basicCredentials) throws AuthenticationException {
        if (this.validator.isValid(basicCredentials.getPassword(), basicCredentials.getUsername(), System.currentTimeMillis())) {
            try {
                UUID userId = UUID.fromString(basicCredentials.getUsername());
                return Optional.of(new User(userId));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Successful authentication of non-UUID?", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

