/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.codec.binary.Hex;
import org.signal.storageservice.Cassandra;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.storage.protos.contacts.StorageItem;
import org.signal.storageservice.storage.protos.contacts.StorageManifest;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupChanges;

public class CassandraStorageService {
    public static CompletableFuture<Boolean> createGroup(Group group, ByteString groupId) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        String grpData = Base64.getEncoder().encodeToString(group.toByteArray());
        String grpId = Base64.getEncoder().encodeToString(groupId.toByteArray());
        StringBuffer qry = new StringBuffer();
        qry.append("INSERT INTO GroupsTable (gid,gr,ver) VALUES ('").append(grpId).append("','").append(grpData).append("','").append(String.valueOf(group.getVersion())).append("')");
        try {
            session.execute(qry.toString());
            result.complete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.complete(false);
        }
        return result;
    }

    public static CompletableFuture<Optional<Group>> getGroup(ByteString groupId) {
        CompletableFuture<Optional<Group>> result;
        block5: {
            Group g = null;
            result = new CompletableFuture<Optional<Group>>();
            Cassandra.DB.connect();
            Session session = Cassandra.DB.getSession();
            String grpId = Base64.getEncoder().encodeToString(groupId.toByteArray());
            StringBuffer qry = new StringBuffer();
            qry.append("select * from groupstable where gid='").append(grpId).append("'");
            try {
                ResultSet results = session.execute(qry.toString());
                Row row = results.one();
                try {
                    if (row != null) {
                        byte[] gd = Base64.getDecoder().decode(row.getString("gr"));
                        g = Group.parseFrom(gd);
                        result.complete(Optional.of(g));
                        break block5;
                    }
                    result.complete(Optional.of(Group.newBuilder().build()));
                }
                catch (InvalidProtocolBufferException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static CompletableFuture<Boolean> createGrpLog(ByteString rowId, int version, GroupChange groupChange, Group group, ByteString groupId) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        String grpChange = Base64.getEncoder().encodeToString(groupChange.toByteArray());
        String columnState = Base64.getEncoder().encodeToString(group.toByteArray());
        String groupIdString = Base64.getEncoder().encodeToString(rowId.toByteArray());
        String grpId = Base64.getEncoder().encodeToString(groupId.toByteArray());
        StringBuffer qry = new StringBuffer();
        qry.append("INSERT INTO GroupLogTable (id,v,c,s,gid) VALUES ('").append(groupIdString).append("','").append(String.valueOf(version)).append("','").append(grpChange).append("','").append(columnState).append("','").append(grpId).append("')");
        try {
            session.execute(qry.toString());
            result.complete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.complete(false);
        }
        return result;
    }

    public static CompletableFuture<Boolean> updateGroup(ByteString groupId, Group group, int version) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        String grpId = Base64.getEncoder().encodeToString(groupId.toByteArray());
        String grpData = Base64.getEncoder().encodeToString(group.toByteArray());
        StringBuffer qry = new StringBuffer();
        qry.append("update  groupstable set ").append("gr = '").append(grpData).append("',").append(" ver ='").append(String.valueOf(group.getVersion())).append("' ").append("where gid='").append(grpId).append("'");
        try {
            session.execute(qry.toString());
            result.complete(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.complete(false);
        }
        return result;
    }

    public static CompletableFuture<List<GroupChanges.GroupChangeState>> getGroupRecordFromVersion(ByteString groupId, int version) {
        Object g = null;
        CompletableFuture<List<GroupChanges.GroupChangeState>> future = new CompletableFuture<List<GroupChanges.GroupChangeState>>();
        LinkedList<GroupChanges.GroupChangeState> results = new LinkedList<GroupChanges.GroupChangeState>();
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        String grpId = Base64.getEncoder().encodeToString(groupId.toByteArray());
        StringBuffer qry = new StringBuffer();
        qry.append("select gid,v,c,s from grouplogtable where gid='").append(grpId).append("'").append(" and v >= '").append(String.valueOf(version)).append("' ALLOW FILTERING");
        try {
            ResultSet rs = session.execute(qry.toString());
            for (Row r : rs) {
                byte[] s = Base64.getDecoder().decode(r.getString("s"));
                byte[] c = Base64.getDecoder().decode(r.getString("c"));
                results.add(GroupChanges.GroupChangeState.newBuilder().setGroupChange(GroupChange.parseFrom(c)).setGroupState(Group.parseFrom(s)).build());
            }
            future.complete(results);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return future;
    }

    public static CompletableFuture<Boolean> setManifest(StorageManifest manifest, ByteString id) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        String manifestVal = Base64.getEncoder().encodeToString(manifest.getValue().toByteArray());
        String idVal = Base64.getEncoder().encodeToString(id.toByteArray());
        StringBuffer selectqry = new StringBuffer();
        selectqry.append("select * from  ManifestTable where id ='").append(idVal).append("'");
        try {
            ResultSet selectRs = session.execute(selectqry.toString());
            Row row = selectRs.one();
            if (row != null) {
                System.out.println("Manifest exist, hence update");
                StringBuffer updateqry = new StringBuffer();
                updateqry.append("UPDATE ManifestTable SET DATA ='").append(manifestVal).append("',").append("ver='").append(String.valueOf(manifest.getVersion())).append("' where id='").append(idVal).append("'");
                session.execute(updateqry.toString());
                result.complete(true);
            } else {
                StringBuffer qry = new StringBuffer();
                qry.append("INSERT INTO ManifestTable (id, data,ver) VALUES ('").append(idVal).append("','").append(manifestVal).append("','").append(String.valueOf(manifest.getVersion())).append("')");
                session.execute(qry.toString());
                result.complete(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static CompletableFuture<Optional<StorageManifest>> getManifest(ByteString id) {
        CompletableFuture<Optional<StorageManifest>> result;
        block5: {
            Object sm = null;
            result = new CompletableFuture<Optional<StorageManifest>>();
            Cassandra.DB.connect();
            Session session = Cassandra.DB.getSession();
            String idVal = Base64.getEncoder().encodeToString(id.toByteArray());
            StringBuffer qry = new StringBuffer();
            qry.append("select * from ManifestTable where id='").append(idVal).append("'");
            try {
                ResultSet results = session.execute(qry.toString());
                Row row = results.one();
                try {
                    if (row != null) {
                        byte[] smd = Base64.getDecoder().decode(row.getString("data"));
                        String ver = row.getString("ver");
                        StorageManifest.Builder contactsManifest = StorageManifest.newBuilder();
                        contactsManifest.setValue(ByteString.copyFrom((byte[])smd));
                        contactsManifest.setVersion(Long.parseLong(ver));
                        result.complete(Optional.of(contactsManifest.build()));
                        break block5;
                    }
                    result.complete(Optional.of(StorageManifest.newBuilder().build()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static CompletableFuture<Optional<StorageManifest>> getIfNotManifestVersion(ByteString id, long version) {
        CompletableFuture<Optional<StorageManifest>> result;
        block5: {
            Object sm = null;
            result = new CompletableFuture<Optional<StorageManifest>>();
            Cassandra.DB.connect();
            Session session = Cassandra.DB.getSession();
            String idVal = Base64.getEncoder().encodeToString(id.toByteArray());
            String vVal = String.valueOf(version);
            StringBuffer qry = new StringBuffer();
            qry.append("select * from ManifestTable where id='").append(idVal).append("'").append(" and ver='").append(vVal).append("'").append(" ALLOW FILTERING");
            try {
                ResultSet results = session.execute(qry.toString());
                Row row = results.one();
                try {
                    if (null != row) {
                        StorageManifest.Builder contactsManifest = StorageManifest.newBuilder();
                        byte[] smd = Base64.getDecoder().decode(row.getString("data"));
                        contactsManifest.setValue(ByteString.copyFrom((byte[])smd));
                        contactsManifest.setVersion(Long.parseLong(row.getString("ver")));
                        result.complete(Optional.of(contactsManifest.build()));
                        break block5;
                    }
                    result.complete(Optional.of(StorageManifest.newBuilder().build()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static CompletableFuture<Void> setSTorageItem(User user, List<StorageItem> inserts, List<ByteString> deletes) {
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        for (StorageItem insert : inserts) {
            StringBuffer insertQry = new StringBuffer();
            insertQry.append("INSERT INTO StorageItemsTable(id,k,d) values(");
            String d = Base64.getEncoder().encodeToString(insert.getValue().toByteArray());
            String k = Base64.getEncoder().encodeToString(insert.getKey().toByteArray());
            String idVal = Base64.getEncoder().encodeToString(CassandraStorageService.getRowKeyFor(user, insert.getKey()).toByteArray());
            insertQry.append("'").append(idVal).append("','").append(k).append("','").append(d).append("')");
            session.execute(insertQry.toString());
        }
        for (ByteString delete : deletes) {
            StringBuffer deleteQry = new StringBuffer();
            deleteQry.append("DELETE from StorageItemsTable WHERE id='");
            String id = Base64.getEncoder().encodeToString(CassandraStorageService.getRowKeyFor(user, delete).toByteArray());
            deleteQry.append(id).append("'");
            session.execute(deleteQry.toString());
        }
        return result;
    }

    public static CompletableFuture<List<StorageItem>> getStorageItem(User user, List<ByteString> keys) {
        CompletableFuture<List<StorageItem>> future = new CompletableFuture<List<StorageItem>>();
        LinkedList<StorageItem> results = new LinkedList<StorageItem>();
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        for (ByteString key : keys) {
            String id = Base64.getEncoder().encodeToString(CassandraStorageService.getRowKeyFor(user, key).toByteArray());
            StringBuffer selectQry = new StringBuffer();
            selectQry.append("select * from StorageItemsTable where id='").append(id).append("'");
            ResultSet rs = session.execute(selectQry.toString());
            Row row = rs.one();
            StorageItem.Builder sIten = StorageItem.newBuilder();
            byte[] dv = Base64.getDecoder().decode(row.getString("d"));
            byte[] kv = Base64.getDecoder().decode(row.getString("k"));
            sIten.setValue(ByteString.copyFrom((byte[])dv));
            sIten.setKey(ByteString.copyFrom((byte[])kv));
            results.add(sIten.build());
        }
        future.complete(results);
        return future;
    }

    public static CompletableFuture<Void> clearStorage(User u) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Cassandra.DB.connect();
        Session session = Cassandra.DB.getSession();
        String kvl = Base64.getEncoder().encodeToString(CassandraStorageService.getRowKeyPrefixFor(u).toByteArray());
        StringBuffer deleteQry = new StringBuffer();
        deleteQry.append("delete  from StorageItemsTable where k='").append(kvl).append("'");
        session.execute(deleteQry.toString());
        Cassandra.DB.shutdown();
        return result;
    }

    private static ByteString getRowKeyPrefixFor(User user) {
        return ByteString.copyFromUtf8((String)(user.getUuid().toString() + "#contact#"));
    }

    private static ByteString getRowKeyFor(User user, ByteString key) {
        return ByteString.copyFromUtf8((String)(user.getUuid().toString() + "#contact#" + Hex.encodeHexString((byte[])key.toByteArray())));
    }
}

