/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.profiles;

import java.security.SecureRandom;
import java.util.UUID;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ServerPublicParams;
import org.signal.zkgroup.VerificationFailedException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.groups.GroupSecretParams;
import org.signal.zkgroup.internal.Native;
import org.signal.zkgroup.profiles.ProfileKey;
import org.signal.zkgroup.profiles.ProfileKeyCredential;
import org.signal.zkgroup.profiles.ProfileKeyCredentialPresentation;
import org.signal.zkgroup.profiles.ProfileKeyCredentialRequestContext;
import org.signal.zkgroup.profiles.ProfileKeyCredentialResponse;
import org.signal.zkgroup.util.UUIDUtil;

public class ClientZkProfileOperations {
    private final ServerPublicParams serverPublicParams;

    public ClientZkProfileOperations(ServerPublicParams serverPublicParams) {
        this.serverPublicParams = serverPublicParams;
    }

    public ProfileKeyCredentialRequestContext createProfileKeyCredentialRequestContext(UUID uuid, ProfileKey profileKey) {
        return this.createProfileKeyCredentialRequestContext(new SecureRandom(), uuid, profileKey);
    }

    public ProfileKeyCredentialRequestContext createProfileKeyCredentialRequestContext(SecureRandom secureRandom, UUID uuid, ProfileKey profileKey) {
        byte[] newContents = new byte[473];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.serverPublicParamsCreateProfileKeyCredentialRequestContextDeterministicJNI(this.serverPublicParams.getInternalContentsForJNI(), random, UUIDUtil.serialize(uuid), profileKey.getInternalContentsForJNI(), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyCredentialRequestContext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKeyCredential receiveProfileKeyCredential(ProfileKeyCredentialRequestContext profileKeyCredentialRequestContext, ProfileKeyCredentialResponse profileKeyCredentialResponse) throws VerificationFailedException {
        if (profileKeyCredentialResponse == null) {
            throw new VerificationFailedException();
        }
        byte[] newContents = new byte[145];
        int ffi_return = Native.serverPublicParamsReceiveProfileKeyCredentialJNI(this.serverPublicParams.getInternalContentsForJNI(), profileKeyCredentialRequestContext.getInternalContentsForJNI(), profileKeyCredentialResponse.getInternalContentsForJNI(), newContents);
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyCredential(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKeyCredentialPresentation createProfileKeyCredentialPresentation(GroupSecretParams groupSecretParams, ProfileKeyCredential profileKeyCredential) {
        return this.createProfileKeyCredentialPresentation(new SecureRandom(), groupSecretParams, profileKeyCredential);
    }

    public ProfileKeyCredentialPresentation createProfileKeyCredentialPresentation(SecureRandom secureRandom, GroupSecretParams groupSecretParams, ProfileKeyCredential profileKeyCredential) {
        byte[] newContents = new byte[713];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.serverPublicParamsCreateProfileKeyCredentialPresentationDeterministicJNI(this.serverPublicParams.getInternalContentsForJNI(), random, groupSecretParams.getInternalContentsForJNI(), profileKeyCredential.getInternalContentsForJNI(), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyCredentialPresentation(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

