/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.groups;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.UUID;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.VerificationFailedException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.groups.GroupSecretParams;
import org.signal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.zkgroup.groups.UuidCiphertext;
import org.signal.zkgroup.internal.Native;
import org.signal.zkgroup.profiles.ProfileKey;
import org.signal.zkgroup.util.UUIDUtil;

public class ClientZkGroupCipher {
    private final GroupSecretParams groupSecretParams;

    public ClientZkGroupCipher(GroupSecretParams groupSecretParams) {
        this.groupSecretParams = groupSecretParams;
    }

    public UuidCiphertext encryptUuid(UUID uuid) {
        byte[] newContents = new byte[65];
        int ffi_return = Native.groupSecretParamsEncryptUuidJNI(this.groupSecretParams.getInternalContentsForJNI(), UUIDUtil.serialize(uuid), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new UuidCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UUID decryptUuid(UuidCiphertext uuidCiphertext) throws VerificationFailedException {
        byte[] newContents = new byte[16];
        int ffi_return = Native.groupSecretParamsDecryptUuidJNI(this.groupSecretParams.getInternalContentsForJNI(), uuidCiphertext.getInternalContentsForJNI(), newContents);
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        return UUIDUtil.deserialize(newContents);
    }

    public ProfileKeyCiphertext encryptProfileKey(ProfileKey profileKey, UUID uuid) {
        byte[] newContents = new byte[65];
        int ffi_return = Native.groupSecretParamsEncryptProfileKeyJNI(this.groupSecretParams.getInternalContentsForJNI(), profileKey.getInternalContentsForJNI(), UUIDUtil.serialize(uuid), newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKeyCiphertext(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProfileKey decryptProfileKey(ProfileKeyCiphertext profileKeyCiphertext, UUID uuid) throws VerificationFailedException {
        byte[] newContents = new byte[32];
        int ffi_return = Native.groupSecretParamsDecryptProfileKeyJNI(this.groupSecretParams.getInternalContentsForJNI(), profileKeyCiphertext.getInternalContentsForJNI(), UUIDUtil.serialize(uuid), newContents);
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new ProfileKey(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public byte[] encryptBlob(byte[] plaintext) throws VerificationFailedException {
        return this.encryptBlob(new SecureRandom(), plaintext);
    }

    public byte[] encryptBlob(SecureRandom secureRandom, byte[] plaintext) throws VerificationFailedException {
        byte[] paddedPlaintext = new byte[plaintext.length + 4];
        System.arraycopy(plaintext, 0, paddedPlaintext, 4, plaintext.length);
        byte[] newContents = new byte[paddedPlaintext.length + 29];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.groupSecretParamsEncryptBlobDeterministicJNI(this.groupSecretParams.getInternalContentsForJNI(), random, paddedPlaintext, newContents);
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        return newContents;
    }

    public byte[] decryptBlob(byte[] blobCiphertext) throws VerificationFailedException {
        byte[] newContents = new byte[blobCiphertext.length - 29];
        int ffi_return = Native.groupSecretParamsDecryptBlobJNI(this.groupSecretParams.getInternalContentsForJNI(), blobCiphertext, newContents);
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        if (newContents.length < 4) {
            throw new VerificationFailedException();
        }
        byte[] padLenBytes = new byte[4];
        System.arraycopy(newContents, 0, padLenBytes, 0, 4);
        int padLen = ByteBuffer.wrap(newContents).getInt();
        if (newContents.length < 4 + padLen) {
            throw new VerificationFailedException();
        }
        byte[] depaddedContents = new byte[newContents.length - (4 + padLen)];
        System.arraycopy(newContents, 4, depaddedContents, 0, newContents.length - (4 + padLen));
        return depaddedContents;
    }
}

