/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message.modifier.checksum;

import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogMessageModifierIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.message.modifier.checksum.ChecksumSyslogMessageModifierConfig;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class ChecksumSyslogMessageModifier
implements SyslogMessageModifierIF {
    private static final long serialVersionUID = -3268914290497005065L;
    protected ChecksumSyslogMessageModifierConfig config = null;

    public static final ChecksumSyslogMessageModifier createCRC32() {
        ChecksumSyslogMessageModifier checksumSyslogMessageModifier = new ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig.createCRC32());
        return checksumSyslogMessageModifier;
    }

    public static final ChecksumSyslogMessageModifier createADLER32() {
        ChecksumSyslogMessageModifier checksumSyslogMessageModifier = new ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig.createADLER32());
        return checksumSyslogMessageModifier;
    }

    public ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig checksumSyslogMessageModifierConfig) {
        this.config = checksumSyslogMessageModifierConfig;
        if (this.config == null) {
            throw new SyslogRuntimeException("Checksum config object cannot be null");
        }
        if (this.config.getChecksum() == null) {
            throw new SyslogRuntimeException("Checksum object cannot be null");
        }
    }

    public ChecksumSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    public synchronized String modify(SyslogIF syslogIF, SyslogConfigIF syslogConfigIF, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        byte[] byArray = SyslogUtility.getBytes(syslogConfigIF, string);
        this.config.getChecksum().update(byArray, 0, string.length());
        stringBuffer.append(this.config.getPrefix());
        stringBuffer.append(Long.toHexString(this.config.getChecksum().getValue()).toUpperCase());
        stringBuffer.append(this.config.getSuffix());
        return stringBuffer.toString();
    }
}

