/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.batching.BatchingCallSettings;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;

@BetaApi(value="This surface is likely to change as the batching surface evolves.")
public final class BigtableBatchingCallSettings
extends UnaryCallSettings<BulkMutation, Void> {
    private BatchingCallSettings<RowMutationEntry, Void, BulkMutation, Void> batchingCallSettings;

    private BigtableBatchingCallSettings(Builder builder) {
        super((UnaryCallSettings.Builder)builder);
        this.batchingCallSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)builder.batchingDescriptor).setBatchingSettings(builder.batchingSettings).setRetrySettings(builder.getRetrySettings()).setRetryableCodes(builder.getRetryableCodes()).build();
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingCallSettings.getBatchingSettings();
    }

    BatchingDescriptor<RowMutationEntry, Void, BulkMutation, Void> getBatchingDescriptor() {
        return this.batchingCallSettings.getBatchingDescriptor();
    }

    static Builder newBuilder(BatchingDescriptor<RowMutationEntry, Void, BulkMutation, Void> batchingDescriptor) {
        return new Builder(batchingDescriptor);
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends UnaryCallSettings.Builder<BulkMutation, Void> {
        private BatchingDescriptor<RowMutationEntry, Void, BulkMutation, Void> batchingDescriptor;
        private BatchingSettings batchingSettings;

        private Builder(@Nonnull BatchingDescriptor<RowMutationEntry, Void, BulkMutation, Void> batchingDescriptor) {
            this.batchingDescriptor = (BatchingDescriptor)Preconditions.checkNotNull(batchingDescriptor, (Object)"batching descriptor can't be null");
        }

        private Builder(@Nonnull BigtableBatchingCallSettings settings) {
            super((UnaryCallSettings)settings);
            this.batchingDescriptor = settings.getBatchingDescriptor();
            this.batchingSettings = settings.getBatchingSettings();
        }

        public Builder setBatchingSettings(@Nonnull BatchingSettings batchingSettings) {
            Preconditions.checkNotNull((Object)batchingSettings, (Object)"batching settings can't be null");
            this.batchingSettings = batchingSettings;
            return this;
        }

        public BatchingSettings getBatchingSettings() {
            return this.batchingSettings;
        }

        public Builder setRetryableCodes(StatusCode.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        public Builder setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        public Builder setRetrySettings(@Nonnull RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        public BigtableBatchingCallSettings build() {
            return new BigtableBatchingCallSettings(this);
        }
    }
}

