/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalExtensionOnly;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

@InternalExtensionOnly
public abstract class Range<T, R extends Range<T, R>>
implements Serializable {
    private BoundType startBound;
    private T start;
    private BoundType endBound;
    private T end;

    Range() {
        this(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
    }

    Range(BoundType startBound, T start, BoundType endBound, T end) {
        this.startBound = startBound;
        this.start = start;
        this.endBound = endBound;
        this.end = end;
    }

    public R of(@Nonnull T startClosed, @Nonnull T endOpen) {
        return ((Range)this.startClosed(startClosed)).endOpen(endOpen);
    }

    public R startUnbounded() {
        this.start = null;
        this.startBound = BoundType.UNBOUNDED;
        return this.thisT();
    }

    public R startOpen(@Nonnull T start) {
        this.start = Preconditions.checkNotNull(start, (Object)"Start can't be null");
        this.startBound = BoundType.OPEN;
        return this.thisT();
    }

    public R startClosed(@Nonnull T start) {
        this.start = Preconditions.checkNotNull(start, (Object)"Start can't be null");
        this.startBound = BoundType.CLOSED;
        return this.thisT();
    }

    public R endUnbounded() {
        this.end = null;
        this.endBound = BoundType.UNBOUNDED;
        return this.thisT();
    }

    public R endOpen(@Nonnull T end) {
        this.end = Preconditions.checkNotNull(end, (Object)"End can't be null");
        this.endBound = BoundType.OPEN;
        return this.thisT();
    }

    public R endClosed(@Nonnull T end) {
        this.end = Preconditions.checkNotNull(end, (Object)"End can't be null");
        this.endBound = BoundType.CLOSED;
        return this.thisT();
    }

    public BoundType getStartBound() {
        return this.startBound;
    }

    public T getStart() {
        Preconditions.checkState((this.startBound != BoundType.UNBOUNDED ? 1 : 0) != 0, (Object)"Start is unbounded");
        return this.start;
    }

    public BoundType getEndBound() {
        return this.endBound;
    }

    public T getEnd() {
        Preconditions.checkState((this.endBound != BoundType.UNBOUNDED ? 1 : 0) != 0, (Object)"End is unbounded");
        return this.end;
    }

    private R thisT() {
        return (R)this;
    }

    public static final class ByteStringRange
    extends AbstractByteStringRange<ByteStringRange>
    implements Serializable {
        private static final long serialVersionUID = 2199230324202930550L;

        public static ByteStringRange prefix(String prefix) {
            return ByteStringRange.prefix(ByteString.copyFromUtf8((String)prefix));
        }

        public static ByteStringRange prefix(ByteString prefix) {
            int offset;
            if (prefix.isEmpty()) {
                return ByteStringRange.unbounded();
            }
            int curByte = 255;
            for (offset = prefix.size() - 1; offset >= 0 && (curByte = prefix.byteAt(offset) & 0xFF) == 255; --offset) {
            }
            if (offset < 0) {
                return (ByteStringRange)ByteStringRange.unbounded().startClosed(prefix);
            }
            ByteString endPrefix = offset == 0 ? ByteString.EMPTY : prefix.substring(0, offset);
            ByteString endSuffix = ByteString.copyFrom((byte[])new byte[]{(byte)(curByte + 1)});
            ByteString end = endPrefix.concat(endSuffix);
            ByteStringRange range = (ByteStringRange)ByteStringRange.unbounded().startClosed(prefix);
            if (!end.isEmpty()) {
                range.endOpen(end);
            }
            return range;
        }

        public static ByteStringRange unbounded() {
            return new ByteStringRange(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
        }

        public static ByteStringRange create(ByteString closedStart, ByteString openEnd) {
            return new ByteStringRange(BoundType.CLOSED, closedStart, BoundType.OPEN, openEnd);
        }

        public static ByteStringRange create(String closedStart, String openEnd) {
            return new ByteStringRange(BoundType.CLOSED, ByteStringRange.wrap(closedStart), BoundType.OPEN, ByteStringRange.wrap(openEnd));
        }

        private ByteStringRange(BoundType startBound, ByteString start, BoundType endBound, ByteString end) {
            super(startBound, start, endBound, end);
        }

        private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
            input.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream output) throws IOException {
            output.defaultWriteObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteStringRange range = (ByteStringRange)o;
            if (this.getStartBound() != range.getStartBound() || this.getEndBound() != range.getEndBound()) {
                return false;
            }
            if (this.getStartBound() != BoundType.UNBOUNDED && !Objects.equal(this.getStart(), range.getStart())) {
                return false;
            }
            return this.getEndBound() == BoundType.UNBOUNDED || Objects.equal(this.getEnd(), range.getEnd());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getStartBound(), this.getStartBound() == BoundType.UNBOUNDED ? null : (ByteString)this.getStart(), this.getEndBound(), this.getEndBound() == BoundType.UNBOUNDED ? null : (ByteString)this.getEnd()});
        }
    }

    public static final class TimestampRange
    extends AbstractTimestampRange<TimestampRange>
    implements Serializable {
        private static final long serialVersionUID = 198219379354720855L;

        public static TimestampRange unbounded() {
            return new TimestampRange(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
        }

        public static TimestampRange create(long closedStart, long openEnd) {
            return new TimestampRange(BoundType.CLOSED, closedStart, BoundType.OPEN, openEnd);
        }

        private TimestampRange(BoundType startBound, Long start, BoundType endBound, Long end) {
            super(startBound, start, endBound, end);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampRange range = (TimestampRange)o;
            if (this.getStartBound() != range.getStartBound() || this.getEndBound() != range.getEndBound()) {
                return false;
            }
            if (this.getStartBound() != BoundType.UNBOUNDED && !Objects.equal(this.getStart(), range.getStart())) {
                return false;
            }
            return this.getEndBound() == BoundType.UNBOUNDED || Objects.equal(this.getEnd(), range.getEnd());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getStartBound(), this.getStartBound() == BoundType.UNBOUNDED ? null : (Long)this.getStart(), this.getEndBound(), this.getEndBound() == BoundType.UNBOUNDED ? null : (Long)this.getEnd()});
        }
    }

    @InternalExtensionOnly
    static abstract class AbstractByteStringRange<R extends AbstractByteStringRange<R>>
    extends Range<ByteString, R>
    implements Cloneable {
        AbstractByteStringRange() {
            this(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
        }

        AbstractByteStringRange(BoundType startBound, ByteString start, BoundType endBound, ByteString end) {
            super(startBound, start, endBound, end);
        }

        @Override
        public R of(String startClosed, String endOpen) {
            return (R)((AbstractByteStringRange)this.of(AbstractByteStringRange.wrap(startClosed), AbstractByteStringRange.wrap(endOpen)));
        }

        @Override
        public R startOpen(@Nonnull String start) {
            return this.startOpen(AbstractByteStringRange.wrap(start));
        }

        @Override
        public R startClosed(@Nonnull String start) {
            return this.startClosed(AbstractByteStringRange.wrap(start));
        }

        @Override
        public R endOpen(@Nonnull String end) {
            return this.endOpen(AbstractByteStringRange.wrap(end));
        }

        @Override
        public R endClosed(@Nonnull String end) {
            return this.endClosed(AbstractByteStringRange.wrap(end));
        }

        @Override
        public R startOpen(@Nonnull ByteString start) {
            Preconditions.checkNotNull((Object)start);
            if (start.isEmpty()) {
                return (R)((AbstractByteStringRange)this.startUnbounded());
            }
            return (R)((AbstractByteStringRange)super.startOpen(start));
        }

        @Override
        public R startClosed(@Nonnull ByteString start) {
            Preconditions.checkNotNull((Object)start);
            if (start.isEmpty()) {
                return (R)((AbstractByteStringRange)this.startUnbounded());
            }
            return (R)((AbstractByteStringRange)super.startClosed(start));
        }

        @Override
        public R endOpen(@Nonnull ByteString end) {
            Preconditions.checkNotNull((Object)end);
            if (end.isEmpty()) {
                return (R)((AbstractByteStringRange)this.endUnbounded());
            }
            return (R)((AbstractByteStringRange)super.endOpen(end));
        }

        @Override
        public R endClosed(@Nonnull ByteString end) {
            Preconditions.checkNotNull((Object)end);
            if (end.isEmpty()) {
                return (R)((AbstractByteStringRange)this.endUnbounded());
            }
            return (R)((AbstractByteStringRange)super.endClosed(end));
        }

        protected R clone() {
            try {
                return (R)((AbstractByteStringRange)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("should never happen", e);
            }
        }

        static ByteString wrap(String str) {
            return ByteString.copyFromUtf8((String)str);
        }
    }

    static abstract class AbstractTimestampRange<R extends AbstractTimestampRange<R>>
    extends Range<Long, R>
    implements Cloneable {
        AbstractTimestampRange() {
        }

        AbstractTimestampRange(BoundType startBound, Long start, BoundType endBound, Long end) {
            super(startBound, start, endBound, end);
        }

        protected R clone() {
            try {
                return (R)((AbstractTimestampRange)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("should never happen", e);
            }
        }
    }

    public static enum BoundType {
        OPEN,
        CLOSED,
        UNBOUNDED;

    }
}

