/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class RestoreTableRequest {
    private final RestoreTableRequest.Builder requestBuilder = com.google.bigtable.admin.v2.RestoreTableRequest.newBuilder();
    private final String backupId;
    private final String clusterId;

    public static RestoreTableRequest of(String clusterId, String backupId) {
        RestoreTableRequest request = new RestoreTableRequest(clusterId, backupId);
        return request;
    }

    private RestoreTableRequest(String clusterId, String backupId) {
        Preconditions.checkNotNull((Object)clusterId);
        Preconditions.checkNotNull((Object)backupId);
        this.backupId = backupId;
        this.clusterId = clusterId;
    }

    public RestoreTableRequest setTableId(String tableId) {
        Preconditions.checkNotNull((Object)tableId);
        this.requestBuilder.setTableId(tableId);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreTableRequest that = (RestoreTableRequest)o;
        return Objects.equal((Object)this.requestBuilder.getTableId(), (Object)that.requestBuilder.getTableId()) && Objects.equal((Object)this.clusterId, (Object)that.clusterId) && Objects.equal((Object)this.backupId, (Object)that.backupId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.getTableId(), this.clusterId, this.backupId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.RestoreTableRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        return this.requestBuilder.setParent(NameUtil.formatInstanceName(projectId, instanceId)).setBackup(NameUtil.formatBackupName(projectId, instanceId, this.clusterId, this.backupId)).build();
    }
}

