/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.AppProfileName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import javax.annotation.Nonnull;

public final class AppProfile {
    private final com.google.bigtable.admin.v2.AppProfile proto;

    @InternalApi
    public static AppProfile fromProto(@Nonnull com.google.bigtable.admin.v2.AppProfile proto) {
        return new AppProfile(proto);
    }

    private AppProfile(@Nonnull com.google.bigtable.admin.v2.AppProfile proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((proto.hasSingleClusterRouting() || proto.hasMultiClusterRoutingUseAny() ? 1 : 0) != 0, (Object)"AppProfile must have a routing policy");
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"AppProfile must have a name");
        this.proto = proto;
    }

    public RoutingPolicy getPolicy() {
        if (this.proto.hasMultiClusterRoutingUseAny()) {
            return MultiClusterRoutingPolicy.of();
        }
        if (this.proto.hasSingleClusterRouting()) {
            return new SingleClusterRoutingPolicy(this.proto.getSingleClusterRouting());
        }
        throw new VerifyException();
    }

    public String getId() {
        AppProfileName fullName = (AppProfileName)Verify.verifyNotNull((Object)AppProfileName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getAppProfile();
    }

    public String getInstanceId() {
        AppProfileName fullName = (AppProfileName)Verify.verifyNotNull((Object)AppProfileName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public String getDescription() {
        return this.proto.getDescription();
    }

    com.google.bigtable.admin.v2.AppProfile toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppProfile that = (AppProfile)o;
        return Objects.equal((Object)this.proto, (Object)that.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }

    public static class MultiClusterRoutingPolicy
    implements RoutingPolicy {
        private static final AppProfile.MultiClusterRoutingUseAny proto = AppProfile.MultiClusterRoutingUseAny.getDefaultInstance();

        public static MultiClusterRoutingPolicy of() {
            return new MultiClusterRoutingPolicy();
        }

        private MultiClusterRoutingPolicy() {
        }

        @InternalApi
        AppProfile.MultiClusterRoutingUseAny toProto() {
            return proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{proto});
        }
    }

    public static class SingleClusterRoutingPolicy
    implements RoutingPolicy {
        private final AppProfile.SingleClusterRouting proto;

        @InternalApi
        public static SingleClusterRoutingPolicy fromProto(AppProfile.SingleClusterRouting proto) {
            return new SingleClusterRoutingPolicy(proto);
        }

        public static SingleClusterRoutingPolicy of(String clusterId) {
            return SingleClusterRoutingPolicy.of(clusterId, false);
        }

        public static SingleClusterRoutingPolicy of(String clusterId, boolean allowTransactionWrites) {
            return SingleClusterRoutingPolicy.fromProto(AppProfile.SingleClusterRouting.newBuilder().setClusterId(clusterId).setAllowTransactionalWrites(allowTransactionWrites).build());
        }

        private SingleClusterRoutingPolicy(AppProfile.SingleClusterRouting proto) {
            this.proto = proto;
        }

        public String getClusterId() {
            return this.proto.getClusterId();
        }

        public boolean getAllowTransactionalWrites() {
            return this.proto.getAllowTransactionalWrites();
        }

        @InternalApi
        AppProfile.SingleClusterRouting toProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleClusterRoutingPolicy that = (SingleClusterRoutingPolicy)o;
            return Objects.equal((Object)this.proto, (Object)that.proto);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.proto});
        }
    }

    public static interface RoutingPolicy {
    }
}

