/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import io.dropwizard.jersey.DefaultValueUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalLongParamConverterProvider
implements ParamConverterProvider {
    private final OptionalLongParamConverter paramConverter = new OptionalLongParamConverter();

    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!OptionalLong.class.equals(rawType)) {
            return null;
        }
        String defaultValue = DefaultValueUtils.getDefaultValue(annotations);
        return defaultValue == null ? this.paramConverter : new OptionalLongParamConverter(defaultValue);
    }

    public static class OptionalLongParamConverter
    implements ParamConverter<OptionalLong> {
        @Nullable
        private final String defaultValue;

        public OptionalLongParamConverter() {
            this(null);
        }

        public OptionalLongParamConverter(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Nullable
        public OptionalLong fromString(String value) {
            try {
                long l = Long.parseLong(value);
                return OptionalLong.of(l);
            }
            catch (NumberFormatException e) {
                if (this.defaultValue != null) {
                    if (this.defaultValue.equals(value)) {
                        throw e;
                    }
                    if (value.isEmpty()) {
                        return null;
                    }
                }
                return OptionalLong.empty();
            }
        }

        public String toString(OptionalLong value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            return value.isPresent() ? Long.toString(value.getAsLong()) : "";
        }
    }
}

