/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.groups;

import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.internal.ByteArray;
import org.signal.zkgroup.internal.Native;

public final class UuidCiphertext
extends ByteArray {
    public static final int SIZE = 65;

    public UuidCiphertext(byte[] contents) throws InvalidInputException {
        super(contents, 65);
        int ffi_return = Native.uuidCiphertextCheckValidContentsJNI(contents);
        if (ffi_return == 2) {
            throw new InvalidInputException("FFI_RETURN_INPUT_ERROR");
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }

    public byte[] serialize() {
        return (byte[])this.contents.clone();
    }
}

