/*
 * Decompiled with CFR 0.152.
 */
package org.signal.zkgroup.auth;

import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.signal.zkgroup.InvalidInputException;
import org.signal.zkgroup.InvalidRedemptionTimeException;
import org.signal.zkgroup.ServerSecretParams;
import org.signal.zkgroup.VerificationFailedException;
import org.signal.zkgroup.ZkGroupError;
import org.signal.zkgroup.auth.AuthCredentialPresentation;
import org.signal.zkgroup.auth.AuthCredentialResponse;
import org.signal.zkgroup.groups.GroupPublicParams;
import org.signal.zkgroup.internal.Native;
import org.signal.zkgroup.util.UUIDUtil;

public class ServerZkAuthOperations {
    private final ServerSecretParams serverSecretParams;

    public ServerZkAuthOperations(ServerSecretParams serverSecretParams) {
        this.serverSecretParams = serverSecretParams;
    }

    public AuthCredentialResponse issueAuthCredential(UUID uuid, int redemptionTime) {
        return this.issueAuthCredential(new SecureRandom(), uuid, redemptionTime);
    }

    public AuthCredentialResponse issueAuthCredential(SecureRandom secureRandom, UUID uuid, int redemptionTime) {
        byte[] newContents = new byte[361];
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        int ffi_return = Native.serverSecretParamsIssueAuthCredentialDeterministicJNI(this.serverSecretParams.getInternalContentsForJNI(), random, UUIDUtil.serialize(uuid), redemptionTime, newContents);
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
        try {
            return new AuthCredentialResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void verifyAuthCredentialPresentation(GroupPublicParams groupPublicParams, AuthCredentialPresentation authCredentialPresentation) throws VerificationFailedException, InvalidRedemptionTimeException {
        this.verifyAuthCredentialPresentation(groupPublicParams, authCredentialPresentation, System.currentTimeMillis());
    }

    public void verifyAuthCredentialPresentation(GroupPublicParams groupPublicParams, AuthCredentialPresentation authCredentialPresentation, long currentTimeMillis) throws VerificationFailedException, InvalidRedemptionTimeException {
        long acceptableStartTime = TimeUnit.MILLISECONDS.convert(authCredentialPresentation.getRedemptionTime() - 1, TimeUnit.DAYS);
        long acceptableEndTime = TimeUnit.MILLISECONDS.convert(authCredentialPresentation.getRedemptionTime() + 2, TimeUnit.DAYS);
        if (currentTimeMillis < acceptableStartTime || currentTimeMillis > acceptableEndTime) {
            throw new InvalidRedemptionTimeException();
        }
        int ffi_return = Native.serverSecretParamsVerifyAuthCredentialPresentationJNI(this.serverSecretParams.getInternalContentsForJNI(), groupPublicParams.getInternalContentsForJNI(), authCredentialPresentation.getInternalContentsForJNI());
        if (ffi_return == 2) {
            throw new VerificationFailedException();
        }
        if (ffi_return != 0) {
            throw new ZkGroupError("FFI_RETURN!=OK");
        }
    }
}

