/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.setup;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.servlets.tasks.GarbageCollectionTask;
import io.dropwizard.servlets.tasks.LogConfigurationTask;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.servlets.tasks.TaskServlet;
import io.dropwizard.setup.AdminFactory;
import java.util.Objects;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminEnvironment
extends ServletEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminEnvironment.class);
    private final HealthCheckRegistry healthChecks;
    private final TaskServlet tasks;

    public AdminEnvironment(MutableServletContextHandler handler, HealthCheckRegistry healthChecks, MetricRegistry metricRegistry, AdminFactory adminFactory) {
        super(handler);
        this.healthChecks = healthChecks;
        this.healthChecks.register("deadlocks", (HealthCheck)new ThreadDeadlockHealthCheck());
        this.tasks = new TaskServlet(metricRegistry, adminFactory.getTasks());
        this.tasks.add((Task)new GarbageCollectionTask());
        this.tasks.add((Task)new LogConfigurationTask());
        this.addServlet("tasks", (Servlet)this.tasks).addMapping(new String[]{"/tasks/*"});
        handler.addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarting(LifeCycle event) {
                AdminEnvironment.this.logTasks();
                AdminEnvironment.this.logHealthChecks();
            }
        });
    }

    public void addTask(Task task) {
        this.tasks.add(Objects.requireNonNull(task));
    }

    private void logTasks() {
        StringBuilder stringBuilder = new StringBuilder(1024).append(String.format("%n%n", new Object[0]));
        for (Task task : this.tasks.getTasks()) {
            String taskClassName = AdminEnvironment.firstNonNull(task.getClass().getCanonicalName(), task.getClass().getName());
            stringBuilder.append(String.format("    %-7s /tasks/%s (%s)%n", "POST", task.getName(), taskClassName));
        }
        LOGGER.info("tasks = {}", (Object)stringBuilder.toString());
    }

    private static <T> T firstNonNull(T first, T second) {
        return first == null ? second : first;
    }

    private void logHealthChecks() {
        if (this.healthChecks.getNames().size() <= 1) {
            LOGGER.warn(String.format("%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!%n!    THIS APPLICATION HAS NO HEALTHCHECKS. THIS MEANS YOU WILL NEVER KNOW      !%n!     IF IT DIES IN PRODUCTION, WHICH MEANS YOU WILL NEVER KNOW IF YOU'RE      !%n!    LETTING YOUR USERS DOWN. YOU SHOULD ADD A HEALTHCHECK FOR EACH OF YOUR    !%n!         APPLICATION'S DEPENDENCIES WHICH FULLY (BUT LIGHTLY) TESTS IT.       !%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", new Object[0]));
        }
        LOGGER.debug("health checks = {}", (Object)this.healthChecks.getNames());
    }
}

