/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;

@Priority(value=1000)
class WebApplicationExceptionCatchingFilter
implements ContainerRequestFilter {
    private final ContainerRequestFilter underlying;

    public WebApplicationExceptionCatchingFilter(ContainerRequestFilter underlying) {
        Objects.requireNonNull(underlying, "Underlying ContainerRequestFilter is not set");
        this.underlying = underlying;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            this.underlying.filter(requestContext);
        }
        catch (WebApplicationException webApplicationException) {
            // empty catch block
        }
    }
}

