/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class AuthenticationException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public AuthenticationException(InetSocketAddress address, String message) {
        super(String.format("Authentication error on host %s: %s", address, message));
        this.address = address;
    }

    private AuthenticationException(InetSocketAddress address, String message, Throwable cause) {
        super(message, cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address != null ? this.address.getAddress() : null;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public DriverException copy() {
        return new AuthenticationException(this.address, this.getMessage(), this);
    }
}

