/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.storage.GroupsTable;
import org.signal.storageservice.storage.Table;
import org.signal.storageservice.storage.protos.contacts.StorageManifest;

public class StorageManifestsTable
extends Table {
    static final String FAMILY = "m";
    static final String COLUMN_VERSION = "ver";
    static final String COLUMN_DATA = "dat";
    private final MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)"storage_metrics");
    private final Timer getTimer = this.metricRegistry.timer(MetricRegistry.name(GroupsTable.class, (String[])new String[]{"get"}));
    private final Timer setTimer = this.metricRegistry.timer(MetricRegistry.name(GroupsTable.class, (String[])new String[]{"create"}));
    private final Timer getIfNotVersionTimer = this.metricRegistry.timer(MetricRegistry.name(GroupsTable.class, (String[])new String[]{"getIfNotVersion"}));

    public StorageManifestsTable(BigtableDataClient client, String tableId) {
        super(client, tableId);
    }

    public CompletableFuture<Boolean> set(User user, StorageManifest manifest) {
        Mutation updateManifestMutation = Mutation.create().setCell(FAMILY, COLUMN_VERSION, 0L, String.valueOf(manifest.getVersion())).setCell(FAMILY, ByteString.copyFromUtf8((String)COLUMN_DATA), 0L, manifest.getValue());
        return this.setIfValueOrEmpty(this.setTimer, this.getRowKeyForManifest(user), FAMILY, COLUMN_VERSION, String.valueOf(manifest.getVersion() - 1L), updateManifestMutation);
    }

    public CompletableFuture<Optional<StorageManifest>> get(User user) {
        return StorageManifestsTable.toFuture(this.client.readRowAsync(this.tableId, this.getRowKeyForManifest(user)), this.getTimer).thenApply(this::getManifestFromRow);
    }

    public CompletableFuture<Optional<StorageManifest>> getIfNotVersion(User user, long version) {
        return StorageManifestsTable.toFuture(this.client.readRowAsync(this.tableId, this.getRowKeyForManifest(user), (Filters.Filter)Filters.FILTERS.condition((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.key().exactMatch(this.getRowKeyForManifest(user))).filter(Filters.FILTERS.family().exactMatch(FAMILY)).filter(Filters.FILTERS.qualifier().exactMatch(COLUMN_VERSION)).filter(Filters.FILTERS.value().exactMatch(String.valueOf(version)))).then(Filters.FILTERS.block()).otherwise(Filters.FILTERS.pass())), this.getIfNotVersionTimer).thenApply(this::getManifestFromRow);
    }

    private ByteString getRowKeyForManifest(User user) {
        return ByteString.copyFromUtf8((String)(user.getUuid().toString() + "#manifest"));
    }

    private Optional<StorageManifest> getManifestFromRow(Row row) {
        if (row == null) {
            return Optional.empty();
        }
        StorageManifest.Builder contactsManifest = StorageManifest.newBuilder();
        List manifestCells = row.getCells(FAMILY);
        contactsManifest.setVersion(Long.valueOf(manifestCells.stream().filter(cell -> COLUMN_VERSION.equals(cell.getQualifier().toStringUtf8())).findFirst().orElseThrow().getValue().toStringUtf8()));
        contactsManifest.setValue(manifestCells.stream().filter(cell -> COLUMN_DATA.equals(cell.getQualifier().toStringUtf8())).findFirst().orElseThrow().getValue());
        return Optional.of(contactsManifest.build());
    }
}

