/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.storage.StorageItemsTable;
import org.signal.storageservice.storage.StorageManifestsTable;
import org.signal.storageservice.storage.protos.contacts.StorageItem;
import org.signal.storageservice.storage.protos.contacts.StorageManifest;

public class StorageManager {
    private final StorageManifestsTable manifestsTable;
    private final StorageItemsTable itemsTable;

    public StorageManager(BigtableDataClient client, String contactManifestsTableId, String contactsTableId) {
        this.manifestsTable = new StorageManifestsTable(client, contactManifestsTableId);
        this.itemsTable = new StorageItemsTable(client, contactsTableId);
    }

    public CompletableFuture<Optional<StorageManifest>> set(User user, StorageManifest manifest, List<StorageItem> inserts, List<ByteString> deletes) {
        return this.manifestsTable.set(user, manifest).thenCompose(updated -> {
            if (updated.booleanValue()) {
                return this.itemsTable.set(user, inserts, deletes).thenApply(nothing -> Optional.empty());
            }
            return this.getManifest(user).thenApply(retrieved -> Optional.of((StorageManifest)retrieved.orElseThrow()));
        });
    }

    public CompletableFuture<Optional<StorageManifest>> getManifest(User user) {
        return this.manifestsTable.get(user);
    }

    public CompletableFuture<Optional<StorageManifest>> getManifestIfNotVersion(User user, long version) {
        return this.manifestsTable.getIfNotVersion(user, version);
    }

    public CompletableFuture<List<StorageItem>> getItems(User user, List<ByteString> keys) {
        return this.itemsTable.get(user, keys);
    }

    public CompletableFuture<Void> clearItems(User user) {
        return this.itemsTable.clear(user);
    }
}

