/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.storage.Table;
import org.signal.storageservice.storage.protos.groups.Group;

public class GroupsTable
extends Table {
    public static final String FAMILY = "g";
    public static final String COLUMN_GROUP_DATA = "gr";
    public static final String COLUMN_VERSION = "ver";
    private final MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)"storage_metrics");
    private final Timer getTimer = this.metricRegistry.timer(MetricRegistry.name(GroupsTable.class, (String[])new String[]{"get"}));
    private final Timer createTimer = this.metricRegistry.timer(MetricRegistry.name(GroupsTable.class, (String[])new String[]{"create"}));
    private final Timer updateTimer = this.metricRegistry.timer(MetricRegistry.name(GroupsTable.class, (String[])new String[]{"update"}));

    public GroupsTable(BigtableDataClient client, String tableId) {
        super(client, tableId);
    }

    public CompletableFuture<Optional<Group>> getGroup(ByteString groupId) {
        return GroupsTable.toFuture(this.client.readRowAsync(this.tableId, groupId), this.getTimer).thenApply(row -> {
            if (row == null) {
                return Optional.empty();
            }
            try {
                ByteString groupData = row.getCells(FAMILY, COLUMN_GROUP_DATA).stream().filter(cell -> cell.getTimestamp() == 0L).findFirst().orElseThrow().getValue();
                return Optional.of(Group.parseFrom(groupData));
            }
            catch (InvalidProtocolBufferException e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    public CompletableFuture<Boolean> createGroup(ByteString groupId, Group group) {
        Mutation mutation = Mutation.create().setCell(FAMILY, ByteString.copyFromUtf8((String)COLUMN_GROUP_DATA), 0L, group.toByteString()).setCell(FAMILY, COLUMN_VERSION, 0L, String.valueOf(group.getVersion()));
        return this.setIfEmpty(this.createTimer, groupId, FAMILY, COLUMN_GROUP_DATA, mutation);
    }

    public CompletableFuture<Boolean> updateGroup(ByteString groupId, Group group) {
        Mutation mutation = Mutation.create().setCell(FAMILY, ByteString.copyFromUtf8((String)COLUMN_GROUP_DATA), 0L, group.toByteString()).setCell(FAMILY, COLUMN_VERSION, 0L, String.valueOf(group.getVersion()));
        return this.setIfValue(this.updateTimer, groupId, FAMILY, COLUMN_VERSION, String.valueOf(group.getVersion() - 1), mutation);
    }
}

