/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.storage.Table;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupChanges;
import org.signal.storageservice.util.Conversions;

public class GroupLogTable
extends Table {
    public static final String FAMILY = "l";
    public static final String COLUMN_VERSION = "v";
    public static final String COLUMN_CHANGE = "c";
    public static final String COLUMN_STATE = "s";
    private final MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)"storage_metrics");
    private final Timer appendTimer = this.metricRegistry.timer(MetricRegistry.name(GroupLogTable.class, (String[])new String[]{"append"}));
    private final Timer getFromVersionTimer = this.metricRegistry.timer(MetricRegistry.name(GroupLogTable.class, (String[])new String[]{"getFromVersion"}));

    public GroupLogTable(BigtableDataClient client, String tableId) {
        super(client, tableId);
    }

    public CompletableFuture<Boolean> append(ByteString groupId, int version, GroupChange groupChange, Group group) {
        return this.setIfEmpty(this.appendTimer, this.getRowId(groupId, version), FAMILY, COLUMN_CHANGE, Mutation.create().setCell(FAMILY, ByteString.copyFromUtf8((String)COLUMN_CHANGE), 0L, groupChange.toByteString()).setCell(FAMILY, COLUMN_VERSION, 0L, String.valueOf(version)).setCell(FAMILY, ByteString.copyFromUtf8((String)COLUMN_STATE), 0L, group.toByteString()));
    }

    public CompletableFuture<List<GroupChanges.GroupChangeState>> getRecordsFromVersion(ByteString groupId, int fromVersionInclusive, int toVersionExclusive) {
        final Timer.Context timerContext = this.getFromVersionTimer.time();
        final CompletableFuture<List<GroupChanges.GroupChangeState>> future = new CompletableFuture<List<GroupChanges.GroupChangeState>>();
        Query query = Query.create((String)this.tableId);
        query.range(this.getRowId(groupId, fromVersionInclusive), this.getRowId(groupId, toVersionExclusive));
        this.client.readRowsAsync(query, (ResponseObserver)new ResponseObserver<Row>(){
            List<GroupChanges.GroupChangeState> results = new LinkedList<GroupChanges.GroupChangeState>();

            public void onStart(StreamController controller) {
            }

            public void onResponse(Row response) {
                try {
                    this.results.add(GroupChanges.GroupChangeState.newBuilder().setGroupChange(GroupChange.parseFrom(((RowCell)response.getCells(GroupLogTable.FAMILY, GroupLogTable.COLUMN_CHANGE).stream().findFirst().orElseThrow()).getValue())).setGroupState(Group.parseFrom(((RowCell)response.getCells(GroupLogTable.FAMILY, GroupLogTable.COLUMN_STATE).stream().findFirst().orElseThrow()).getValue())).build());
                }
                catch (InvalidProtocolBufferException e) {
                    future.completeExceptionally(e);
                }
            }

            public void onError(Throwable t) {
                timerContext.close();
                future.completeExceptionally(t);
            }

            public void onComplete() {
                timerContext.close();
                future.complete(this.results);
            }
        });
        return future;
    }

    private ByteString getRowId(ByteString groupId, int version) {
        return groupId.concat(ByteString.copyFromUtf8((String)"#")).concat(ByteString.copyFrom((byte[])Conversions.intToByteArray(version)));
    }
}

