/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.signal.storageservice.util.Pair;

public class BackupsManager {
    private static final DateTimeFormatter BACKUP_ID_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'", Locale.US).withZone(ZoneOffset.UTC);
    private final BigtableTableAdminClient client;
    private final String clusterId;
    private final Collection<String> tableIds;

    public BackupsManager(BigtableTableAdminClient client, String clusterId, Collection<String> tableIds) {
        this.client = client;
        this.clusterId = clusterId;
        this.tableIds = tableIds;
    }

    public CompletableFuture<Map<String, Backup>> createBackups() {
        Instant backupTime = Instant.now();
        Instant expireTime = backupTime.plus(7L, ChronoUnit.DAYS);
        ArrayList futures = new ArrayList(this.tableIds.size());
        for (final String tableId : this.tableIds) {
            CreateBackupRequest request = CreateBackupRequest.of((String)this.clusterId, (String)BackupsManager.createBackupId(tableId, backupTime));
            request.setExpireTime(BackupsManager.convertInstantToBigtableInstant(expireTime));
            request.setSourceTableId(tableId);
            final CompletableFuture completableFuture = new CompletableFuture();
            ApiFuture apiFuture = this.client.createBackupAsync(request);
            ApiFutures.addCallback((ApiFuture)apiFuture, (ApiFutureCallback)new ApiFutureCallback<Backup>(){

                public void onFailure(Throwable t) {
                    completableFuture.completeExceptionally(t);
                }

                public void onSuccess(Backup result) {
                    completableFuture.complete(new Pair<String, Backup>(tableId, result));
                }
            }, (Executor)MoreExecutors.directExecutor());
            futures.add(completableFuture);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return completableFuture.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toMap(Pair::first, Pair::second)));
    }

    private static String createBackupId(String tableId, Instant backupTime) {
        return BACKUP_ID_FORMATTER.format(backupTime) + "-" + tableId;
    }

    private static org.threeten.bp.Instant convertInstantToBigtableInstant(Instant instant) {
        return org.threeten.bp.Instant.ofEpochSecond((long)instant.getEpochSecond(), (long)instant.getNano());
    }
}

