/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.auth;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.signal.storageservice.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalServiceCredentialValidator {
    private final Logger logger = LoggerFactory.getLogger(ExternalServiceCredentialValidator.class);
    private final byte[] key;

    public ExternalServiceCredentialValidator(byte[] key) {
        this.key = key;
    }

    public boolean isValid(String token, String number, long currentTimeMillis) {
        String[] parts = token.split(":");
        Mac mac = this.getMacInstance();
        if (parts.length != 3) {
            return false;
        }
        if (!number.equals(parts[0])) {
            return false;
        }
        if (!this.isValidTime(parts[1], currentTimeMillis)) {
            return false;
        }
        return this.isValidSignature(parts[0] + ":" + parts[1], parts[2], mac);
    }

    private boolean isValidTime(String timeString, long currentTimeMillis) {
        try {
            long tokenTime = Long.parseLong(timeString);
            long ourTime = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
            return TimeUnit.SECONDS.toHours(Math.abs(ourTime - tokenTime)) < 24L;
        }
        catch (NumberFormatException e) {
            this.logger.warn("Number Format", (Throwable)e);
            return false;
        }
    }

    private boolean isValidSignature(String prefix, String suffix, Mac mac) {
        try {
            byte[] ourSuffix = Util.truncate(this.getHmac(this.key, prefix.getBytes(), mac), 10);
            byte[] theirSuffix = Hex.decodeHex((char[])suffix.toCharArray());
            return MessageDigest.isEqual(ourSuffix, theirSuffix);
        }
        catch (DecoderException e) {
            this.logger.warn("DirectoryCredentials", (Throwable)e);
            return false;
        }
    }

    private Mac getMacInstance() {
        try {
            return Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] getHmac(byte[] key, byte[] input, Mac mac) {
        try {
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }
}

