/*
 * Decompiled with CFR 0.152.
 */
package org.signal.storageservice.storage;

import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.signal.storageservice.CassandraStorageService;
import org.signal.storageservice.auth.User;
import org.signal.storageservice.storage.protos.contacts.StorageManifest;

public class StorageManifestsTable {
    static final String FAMILY = "m";
    static final String COLUMN_VERSION = "ver";
    static final String COLUMN_DATA = "dat";

    public CompletableFuture<Boolean> set(User user, StorageManifest manifest) {
        return CassandraStorageService.setManifest(manifest, this.getRowKeyForManifest(user));
    }

    public CompletableFuture<Optional<StorageManifest>> get(User user) {
        return CassandraStorageService.getManifest(this.getRowKeyForManifest(user));
    }

    public CompletableFuture<Optional<StorageManifest>> getIfNotVersion(User user, long version) {
        return CassandraStorageService.getIfNotManifestVersion(this.getRowKeyForManifest(user), version);
    }

    private ByteString getRowKeyForManifest(User user) {
        return ByteString.copyFromUtf8((String)(user.getUuid().toString() + "#manifest"));
    }

    private Optional<StorageManifest> getManifestFromRow(Row row) {
        if (row == null) {
            return Optional.empty();
        }
        StorageManifest.Builder contactsManifest = StorageManifest.newBuilder();
        List manifestCells = row.getCells(FAMILY);
        contactsManifest.setVersion(Long.valueOf(manifestCells.stream().filter(cell -> COLUMN_VERSION.equals(cell.getQualifier().toStringUtf8())).findFirst().orElseThrow().getValue().toStringUtf8()));
        contactsManifest.setValue(manifestCells.stream().filter(cell -> COLUMN_DATA.equals(cell.getQualifier().toStringUtf8())).findFirst().orElseThrow().getValue());
        return Optional.of(contactsManifest.build());
    }
}

